/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server.management.impl;

import javax.management.ObjectName;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.QueueControl;
import org.apache.activemq.artemis.api.jms.management.ConnectionFactoryControl;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;
import org.apache.activemq.artemis.api.jms.management.JMSServerControl;
import org.apache.activemq.artemis.api.jms.management.TopicControl;
import org.apache.activemq.artemis.core.messagecounter.MessageCounter;
import org.apache.activemq.artemis.core.messagecounter.MessageCounterManager;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.management.impl.JMSConnectionFactoryControlImpl;
import org.apache.activemq.artemis.jms.management.impl.JMSQueueControlImpl;
import org.apache.activemq.artemis.jms.management.impl.JMSServerControlImpl;
import org.apache.activemq.artemis.jms.management.impl.JMSTopicControlImpl;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.management.JMSManagementService;

public class JMSManagementServiceImpl
implements JMSManagementService {
    private final ManagementService managementService;
    private final JMSServerManager jmsServerManager;

    public JMSManagementServiceImpl(ManagementService managementService, ActiveMQServer server, JMSServerManager jmsServerManager) {
        this.managementService = managementService;
        this.jmsServerManager = jmsServerManager;
    }

    @Override
    public synchronized JMSServerControl registerJMSServer(JMSServerManager server) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSServerObjectName();
        JMSServerControlImpl control = new JMSServerControlImpl(server);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.server", (Object)control);
        return control;
    }

    @Override
    public synchronized void unregisterJMSServer() throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSServerObjectName();
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.server");
    }

    @Override
    public synchronized void registerQueue(ActiveMQQueue queue, Queue serverQueue) throws Exception {
        QueueControl coreQueueControl = (QueueControl)this.managementService.getResource("core.queue." + queue.getAddress());
        MessageCounterManager messageCounterManager = this.managementService.getMessageCounterManager();
        MessageCounter counter = new MessageCounter(queue.getName(), null, serverQueue, false, coreQueueControl.isDurable(), messageCounterManager.getMaxDayCount());
        messageCounterManager.registerMessageCounter(queue.getName(), counter);
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSQueueObjectName(queue.getQueueName());
        JMSQueueControlImpl control = new JMSQueueControlImpl((ActiveMQDestination)queue, coreQueueControl, this.jmsServerManager, counter);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.queue." + queue.getQueueName(), (Object)control);
    }

    @Override
    public synchronized void unregisterQueue(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSQueueObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.queue." + name);
    }

    @Override
    public synchronized void registerTopic(ActiveMQTopic topic) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSTopicObjectName(topic.getTopicName());
        AddressControl addressControl = (AddressControl)this.managementService.getResource("core.address." + topic.getAddress());
        JMSTopicControlImpl control = new JMSTopicControlImpl((ActiveMQDestination)topic, this.jmsServerManager, addressControl, this.managementService);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.topic." + topic.getTopicName(), (Object)control);
    }

    @Override
    public synchronized void unregisterTopic(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getJMSTopicObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.topic." + name);
    }

    @Override
    public synchronized void registerConnectionFactory(String name, ConnectionFactoryConfiguration cfConfig, ActiveMQConnectionFactory connectionFactory) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getConnectionFactoryObjectName(name);
        JMSConnectionFactoryControlImpl control = new JMSConnectionFactoryControlImpl(cfConfig, connectionFactory, this.jmsServerManager, name);
        this.managementService.registerInJMX(objectName, (Object)control);
        this.managementService.registerInRegistry("jms.connectionfactory." + name, (Object)control);
    }

    @Override
    public synchronized void unregisterConnectionFactory(String name) throws Exception {
        ObjectName objectName = this.managementService.getObjectNameBuilder().getConnectionFactoryObjectName(name);
        this.managementService.unregisterFromJMX(objectName);
        this.managementService.unregisterFromRegistry("jms.connectionfactory." + name);
    }

    @Override
    public void stop() throws Exception {
        for (Object resource : this.managementService.getResources(ConnectionFactoryControl.class)) {
            this.unregisterConnectionFactory(((ConnectionFactoryControl)resource).getName());
        }
        for (Object resource : this.managementService.getResources(JMSQueueControl.class)) {
            this.unregisterQueue(((JMSQueueControl)resource).getName());
        }
        for (Object resource : this.managementService.getResources(TopicControl.class)) {
            this.unregisterTopic(((TopicControl)resource).getName());
        }
    }
}

