/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPEnforcer;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.AlgorithmSuiteValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.EncryptedKeyProcessor;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.str.STRParserParameters;
import org.apache.wss4j.dom.str.STRParserResult;
import org.apache.wss4j.dom.str.SecurityTokenRefSTRParser;
import org.apache.wss4j.dom.util.EncryptionUtils;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.X509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedDataProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptedDataProcessor.class);

    @Override
    public List<WSSecurityEngineResult> handleToken(Element elem, RequestData request, WSDocInfo wsDocInfo) throws WSSecurityException {
        Element decryptedElem;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found EncryptedData element");
        }
        String encryptedDataId = elem.getAttributeNS(null, "Id");
        Element kiElem = XMLUtils.getDirectChildElement((Node)elem, (String)"KeyInfo", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (kiElem == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noKeyinfo");
        }
        String symEncAlgo = X509Util.getEncAlgo(elem);
        EncryptedDataProcessor.checkBSPCompliance(symEncAlgo, request.getBSPEnforcer());
        Element secRefToken = XMLUtils.getDirectChildElement((Node)kiElem, (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        Element encryptedKeyElement = XMLUtils.getDirectChildElement((Node)kiElem, (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
        if (request.isRequireSignedEncryptedDataElements()) {
            List<WSSecurityEngineResult> signedResults = wsDocInfo.getResultsByTag(2);
            WSSecurityUtil.verifySignedElement(elem, signedResults);
        }
        SecretKey key = null;
        List<WSSecurityEngineResult> encrKeyResults = null;
        Principal principal = null;
        if (secRefToken != null) {
            STRParserParameters parameters = new STRParserParameters();
            parameters.setData(request);
            parameters.setWsDocInfo(wsDocInfo);
            parameters.setStrElement(secRefToken);
            if (symEncAlgo != null) {
                parameters.setDerivationKeyLength(KeyUtils.getKeyLength((String)symEncAlgo));
            }
            SecurityTokenRefSTRParser strParser = new SecurityTokenRefSTRParser();
            STRParserResult parserResult = strParser.parseSecurityTokenReference(parameters);
            byte[] secretKey = parserResult.getSecretKey();
            principal = parserResult.getPrincipal();
            key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])secretKey);
            encrKeyResults = new ArrayList<WSSecurityEngineResult>();
        } else if (encryptedKeyElement != null) {
            EncryptedKeyProcessor encrKeyProc = new EncryptedKeyProcessor();
            encrKeyResults = encrKeyProc.handleToken(encryptedKeyElement, request, wsDocInfo);
            byte[] symmKey = (byte[])encrKeyResults.get(0).get("secret");
            key = KeyUtils.prepareSecretKey((String)symEncAlgo, (byte[])symmKey);
        } else {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noEncKey");
        }
        AlgorithmSuite algorithmSuite = request.getAlgorithmSuite();
        if (algorithmSuite != null) {
            AlgorithmSuiteValidator algorithmSuiteValidator = new AlgorithmSuiteValidator(algorithmSuite);
            if (principal instanceof WSDerivedKeyTokenPrincipal) {
                algorithmSuiteValidator.checkDerivedKeyAlgorithm(((WSDerivedKeyTokenPrincipal)principal).getAlgorithm());
                algorithmSuiteValidator.checkEncryptionDerivedKeyLength(((WSDerivedKeyTokenPrincipal)principal).getLength());
            }
            algorithmSuiteValidator.checkSymmetricKeyLength(key.getEncoded().length);
            algorithmSuiteValidator.checkSymmetricEncryptionAlgorithm(symEncAlgo);
        }
        WSDataRef dataRef = EncryptionUtils.decryptEncryptedData(elem.getOwnerDocument(), encryptedDataId, elem, key, symEncAlgo, request);
        WSSecurityEngineResult result = new WSSecurityEngineResult(4, Collections.singletonList(dataRef));
        if (!"".equals(encryptedDataId)) {
            result.put("id", encryptedDataId);
        }
        wsDocInfo.addResult(result);
        wsDocInfo.addTokenElement(elem);
        LinkedList<WSSecurityEngineResult> completeResults = new LinkedList<WSSecurityEngineResult>();
        completeResults.addAll(encrKeyResults);
        completeResults.add(result);
        WSSConfig wssConfig = request.getWssConfig();
        if (wssConfig != null && (decryptedElem = dataRef.getProtectedElement()) != null) {
            QName el = new QName(decryptedElem.getNamespaceURI(), decryptedElem.getLocalName());
            Processor proc = request.getWssConfig().getProcessor(el);
            if (proc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Processing decrypted element with: " + proc.getClass().getName());
                }
                List<WSSecurityEngineResult> results = proc.handleToken(decryptedElem, request, wsDocInfo);
                completeResults.addAll(0, results);
                return completeResults;
            }
        }
        return completeResults;
    }

    private static void checkBSPCompliance(String encAlgo, BSPEnforcer bspEnforcer) throws WSSecurityException {
        if (encAlgo == null) {
            bspEnforcer.handleBSPRule(BSPRule.R5601);
        }
        if (!("http://www.w3.org/2001/04/xmlenc#tripledes-cbc".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes128-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes128-gcm".equals(encAlgo) || "http://www.w3.org/2001/04/xmlenc#aes256-cbc".equals(encAlgo) || "http://www.w3.org/2009/xmlenc11#aes256-gcm".equals(encAlgo))) {
            bspEnforcer.handleBSPRule(BSPRule.R5620);
        }
    }
}

