/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.txn.subsystem.Attribute;
import org.jboss.as.txn.subsystem.CMResourceResourceDefinition;
import org.jboss.as.txn.subsystem.Element;
import org.jboss.as.txn.subsystem.Namespace;
import org.jboss.as.txn.subsystem.TransactionSubsystem14Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class TransactionSubsystem15Parser
extends TransactionSubsystem14Parser {
    public static final TransactionSubsystem15Parser INSTANCE = new TransactionSubsystem15Parser();

    private TransactionSubsystem15Parser() {
        super(Namespace.TRANSACTIONS_1_5);
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, Element element, List<ModelNode> operations, ModelNode subsystemOperation, ModelNode logStoreOperation) throws XMLStreamException {
        switch (element) {
            case RECOVERY_ENVIRONMENT: {
                this.parseRecoveryEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case CORE_ENVIRONMENT: {
                this.parseCoreEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case COORDINATOR_ENVIRONMENT: {
                this.parseCoordinatorEnvironmentElement(reader, subsystemOperation);
                break;
            }
            case OBJECT_STORE: {
                this.parseObjectStoreEnvironmentElementAndEnrichOperation(reader, subsystemOperation);
                break;
            }
            case JTS: {
                this.parseJts(reader, subsystemOperation);
                break;
            }
            case USE_HORNETQ_STORE: {
                if (this.choiceObjectStoreEncountered) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.choiceObjectStoreEncountered = true;
                this.parseUseJournalstore(reader, logStoreOperation, subsystemOperation);
                subsystemOperation.get("use-journal-store").set(true);
                break;
            }
            case JDBC_STORE: {
                if (this.choiceObjectStoreEncountered) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                this.choiceObjectStoreEncountered = true;
                this.parseJdbcStoreElementAndEnrichOperation(reader, logStoreOperation, subsystemOperation);
                subsystemOperation.get("use-jdbc-store").set(true);
                break;
            }
            case CM_RESOURCES: {
                this.parseCMs(reader, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseCMs(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CM_RESPOURCE: {
                    this.parseCM(reader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseCM(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "transactions");
        address.protect();
        ModelNode cmrAddress = address.clone();
        ModelNode cmrOperation = new ModelNode();
        cmrOperation.get("operation").set("add");
        String jndiName = null;
        block15: for (Attribute attribute : Attribute.values()) {
            switch (attribute) {
                case JNDI_NAME: {
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, CMResourceResourceDefinition.JNDI_NAME.getXmlName(), null);
                    continue block15;
                }
            }
        }
        if (jndiName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{CMResourceResourceDefinition.JNDI_NAME.getXmlName()});
        }
        cmrAddress.add("commit-markable-resource", jndiName);
        while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (Element.forName(reader.getLocalName()) == Element.CM_RESPOURCE) {
                        cmrAddress.protect();
                        cmrOperation.get("address").set(cmrAddress);
                        operations.add(cmrOperation);
                        return;
                    }
                    if (Element.forName(reader.getLocalName()) != Element.UNKNOWN) break;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Element.forName(reader.getLocalName())) {
                        case CM_TABLE: {
                            block17: for (Attribute attribute : Attribute.values()) {
                                switch (attribute) {
                                    case NAME: {
                                        this.addAttribute(reader, cmrOperation, CMResourceResourceDefinition.CM_TABLE_NAME);
                                        continue block17;
                                    }
                                    case CM_TABLE_BATCH_SIZE: {
                                        this.addAttribute(reader, cmrOperation, CMResourceResourceDefinition.CM_TABLE_BATCH_SIZE);
                                        continue block17;
                                    }
                                    case CM_TABLE_IMMEDIATE_CLEANUP: {
                                        this.addAttribute(reader, cmrOperation, CMResourceResourceDefinition.CM_TABLE_IMMEDIATE_CLEANUP);
                                        continue block17;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void addAttribute(XMLExtendedStreamReader reader, ModelNode operation, SimpleAttributeDefinition attributeDefinition) throws XMLStreamException {
        String value = this.rawAttributeText((XMLStreamReader)reader, attributeDefinition.getXmlName(), null);
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attributeDefinition.getXmlName()});
        }
        attributeDefinition.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName, String defaultValue) {
        return reader.getAttributeValue("", attributeName) == null ? defaultValue : reader.getAttributeValue("", attributeName).trim();
    }
}

