/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.messaging.context.SAMLMessageInfoContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.storage.ReplayCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReplaySecurityHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MessageReplaySecurityHandler.class);
    @NonnullAfterInit
    private ReplayCache replayCache;
    private boolean requiredRule = true;
    @Duration
    @NonNegative
    private long expires = 180000L;

    @NonnullAfterInit
    public ReplayCache getReplayCache() {
        return this.replayCache;
    }

    public void setReplayCache(@Nonnull ReplayCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.replayCache = (ReplayCache)Constraint.isNotNull((Object)cache, (String)"ReplayCache cannot be null");
    }

    public void setRequiredRule(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredRule = flag;
    }

    @NonNegative
    public long getExpires() {
        return this.expires;
    }

    public void setExpires(@Duration @NonNegative long exp) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.expires = Constraint.isGreaterThanOrEqual((long)0L, (long)exp, (String)"Expiration must be greater than or equal to 0");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.getReplayCache(), (String)"ReplayCache cannot be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SAMLMessageInfoContext msgInfoContext;
        String messageId;
        SAMLPeerEntityContext peerContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
        String entityID = StringSupport.trimOrNull((String)peerContext.getEntityId());
        if (entityID == null) {
            entityID = "(unknown)";
        }
        if ((messageId = StringSupport.trimOrNull((String)(msgInfoContext = (SAMLMessageInfoContext)messageContext.getSubcontext(SAMLMessageInfoContext.class, true)).getMessageId())) == null) {
            if (this.requiredRule) {
                this.log.warn("{} Message contained no ID, replay check not possible", (Object)this.getLogPrefix());
                throw new MessageHandlerException("SAML message from issuer " + entityID + " did not contain an ID");
            }
            this.log.debug("{} Message contained no ID, rule is optional, skipping further processing", (Object)this.getLogPrefix());
            return;
        }
        DateTime issueInstant = msgInfoContext.getMessageIssueInstant();
        if (issueInstant == null) {
            issueInstant = new DateTime();
        }
        this.log.debug("{} Evaluating message replay for message ID '{}', issue instant '{}', entityID '{}'", new Object[]{this.getLogPrefix(), messageId, issueInstant, entityID});
        if (!this.getReplayCache().check(((Object)((Object)this)).getClass().getName(), messageId, issueInstant.getMillis() + this.expires)) {
            this.log.warn("{} Replay detected of message '{}' from issuer '{}'", new Object[]{this.getLogPrefix(), messageId, entityID});
            throw new MessageHandlerException("Rejecting replayed message ID '" + messageId + "' from issuer " + entityID);
        }
    }
}

