/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="DGENDPT", length=4)
public interface EndpointLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = EndpointLogger.class.getPackage().getName();
    public static final EndpointLogger ROOT_LOGGER = (EndpointLogger)Logger.getMessageLogger(EndpointLogger.class, (String)ROOT_LOGGER_CATEGORY);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10000, value="%s starting")
    public void endpointStarting(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10001, value="%s listening on %s")
    public void endpointStarted(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10002, value="%s mapped to %s/%s")
    public void httpEndpointStarted(String var1, String var2, String var3);

    @Message(id=10003, value="No connector is defined in the endpoint subsystem")
    public StartException noConnectorDefined();

    @Message(id=10004, value="Failed to start %s")
    public StartException failedStart(@Cause Throwable var1, String var2);

    @Message(id=10005, value="Failed to instantiate connector %s")
    public StartException failedConnectorInstantiation(@Cause Throwable var1, String var2);

    @Message(id=10006, value="Failed to instantiate transport for connector %s")
    public StartException failedTransportInstantiation(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10007, value="Starting connector %s")
    public void connectorStarting(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10008, value="Stopped connector %s")
    public void connectorStopped(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10009, value="Stopping connector %s")
    public void connectorStopping(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10010, value="Failed to stop connector %s")
    public void connectorStopFailed(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10011, value="Failed to determine servlet")
    public void failedToDetermineServlet(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10012, value="Could not stop context")
    public void contextStopFailed(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10013, value="Could not destroy context")
    public void contextDestroyFailed(@Cause Throwable var1);

    @Message(id=10014, value="Could not set the CacheManager on the REST Server")
    public StartException restCacheManagerInjectionFailed(@Cause Throwable var1);

    @Message(id=10015, value="Could not create the web context for the REST Server")
    public StartException restContextCreationFailed(@Cause Throwable var1);

    @Message(id=10016, value="Could not start the web context for the REST Server")
    public StartException restContextStartFailed(@Cause Throwable var1);

    @Message(id=10017, value="Failed to locate ServerBootstrap")
    public ServiceRegistryException cannotLocateServerBootstrap(@Cause Throwable var1);

    @Message(id=10018, value="Endpoint '%s' requires SSL, but no SSL context is available in realm '%s'")
    public StartException noSSLContext(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10019, value="The topology update timeout configuration is ignored")
    public void topologyUpdateTimeoutIgnored();

    @Message(id=10020, value="Invalid QOP value: %s")
    public IllegalStateException invalidQOPV(String var1);

    @Message(id=10021, value="Invalid Strength value: %s")
    public IllegalStateException invalidStrength(String var1);

    @Message(id=10022, value="Cannot retrieve authorization information for user %s")
    public SecurityException cannotRetrieveAuthorizationInformation(@Cause Throwable var1, String var2);

    @Message(id=10023, value="Endpoint '%s' requires Client Certificates, but no Trust Store is available in realm '%s'")
    public StartException noSSLTrustStore(String var1, String var2);

    @Message(id=10024, value="Invalid authorizationId %s")
    public IllegalArgumentException invalidAuthorizationId(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10025, value="Unable to instantiate class \"%s\": %s")
    public void cannotInstantiateClass(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10026, value="No @NamedFactory annotation found in class: %s")
    public void noFactoryName(String var1);

    @Message(id=10027, value="Service not started")
    public IllegalStateException serviceNotStarted();

    @Message(id=10028, value="%s is null")
    public String nullVar(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10029, value="Ignoring duplicate marshaller deployment found in %s. A marshaller has already been installed")
    public void duplicateMarshallerDeployment(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10030, value="virtual-host attribute not in use")
    public void virtualHostNotInUse();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10031, value="The topology cache-suffix attribute is ignored")
    public void topologyCacheSuffixIgnored();
}

