/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.filter.impl;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.FilterConstants;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.selector.filter.BooleanExpression;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.filter.Filterable;
import org.apache.activemq.artemis.selector.impl.SelectorParser;

public class FilterImpl
implements Filter {
    private final SimpleString sfilterString;
    private final BooleanExpression booleanExpression;

    public static Filter createFilter(String filterStr) throws ActiveMQException {
        return FilterImpl.createFilter(SimpleString.toSimpleString(filterStr == null ? null : filterStr.trim()));
    }

    public static Filter createFilter(SimpleString filterStr) throws ActiveMQException {
        BooleanExpression booleanExpression;
        if (filterStr == null || filterStr.length() == 0) {
            return null;
        }
        try {
            booleanExpression = SelectorParser.parse(filterStr.toString());
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.invalidFilter(e, filterStr);
            throw ActiveMQMessageBundle.BUNDLE.invalidFilter(e, filterStr);
        }
        return new FilterImpl(filterStr, booleanExpression);
    }

    private FilterImpl(SimpleString str, BooleanExpression expression) {
        this.sfilterString = str;
        this.booleanExpression = expression;
    }

    @Override
    public SimpleString getFilterString() {
        return this.sfilterString;
    }

    @Override
    public synchronized boolean match(ServerMessage message) {
        try {
            boolean result = this.booleanExpression.matches(new FilterableServerMessage(message));
            return result;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.invalidFilter(e, this.sfilterString);
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sfilterString == null ? 0 : this.sfilterString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterImpl other = (FilterImpl)obj;
        return !(this.sfilterString == null ? other.sfilterString != null : !this.sfilterString.equals(other.sfilterString));
    }

    public String toString() {
        return "FilterImpl [sfilterString=" + this.sfilterString + "]";
    }

    private static Object getHeaderFieldValue(ServerMessage msg, SimpleString fieldName) {
        if (FilterConstants.ACTIVEMQ_USERID.equals(fieldName)) {
            return new SimpleString("ID:" + msg.getUserID());
        }
        if (FilterConstants.ACTIVEMQ_PRIORITY.equals(fieldName)) {
            return (int)msg.getPriority();
        }
        if (FilterConstants.ACTIVEMQ_TIMESTAMP.equals(fieldName)) {
            return msg.getTimestamp();
        }
        if (FilterConstants.ACTIVEMQ_DURABLE.equals(fieldName)) {
            return msg.isDurable() ? FilterConstants.DURABLE : FilterConstants.NON_DURABLE;
        }
        if (FilterConstants.ACTIVEMQ_EXPIRATION.equals(fieldName)) {
            return msg.getExpiration();
        }
        if (FilterConstants.ACTIVEMQ_SIZE.equals(fieldName)) {
            return msg.getEncodeSize();
        }
        return null;
    }

    private static class FilterableServerMessage
    implements Filterable {
        private final ServerMessage message;

        public FilterableServerMessage(ServerMessage message) {
            this.message = message;
        }

        @Override
        public Object getProperty(String id) {
            Object result = null;
            if (id.startsWith(FilterConstants.ACTIVEMQ_PREFIX.toString())) {
                result = FilterImpl.getHeaderFieldValue(this.message, new SimpleString(id));
            }
            if (result == null) {
                result = this.message.getObjectProperty(new SimpleString(id));
            }
            if (result != null && result.getClass() == SimpleString.class) {
                result = result.toString();
            }
            return result;
        }

        @Override
        public <T> T getBodyAs(Class<T> type) throws FilterException {
            return null;
        }

        @Override
        public Object getLocalConnectionId() {
            return null;
        }
    }
}

