/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl;

import java.util.ArrayList;
import java.util.Set;
import javax.management.MBeanOperationInfo;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.core.management.impl.AbstractControl;
import org.apache.activemq.artemis.core.management.impl.MBeanInfoHelper;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class AddressControlImpl
extends AbstractControl
implements AddressControl {
    private final SimpleString address;
    private final PostOffice postOffice;
    private final PagingManager pagingManager;
    private final HierarchicalRepository<Set<Role>> securityRepository;

    public AddressControlImpl(SimpleString address, PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, HierarchicalRepository<Set<Role>> securityRepository) throws Exception {
        super(AddressControl.class, storageManager);
        this.address = address;
        this.postOffice = postOffice;
        this.pagingManager = pagingManager;
        this.securityRepository = securityRepository;
    }

    @Override
    public String getAddress() {
        return this.address.toString();
    }

    @Override
    public String[] getQueueNames() throws Exception {
        this.clearIO();
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.address);
            ArrayList<String> queueNames = new ArrayList<String>();
            for (Binding binding : bindings.getBindings()) {
                if (!(binding instanceof QueueBinding)) continue;
                queueNames.add(binding.getUniqueName().toString());
            }
            String[] stringArray = queueNames.toArray(new String[queueNames.size()]);
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public String[] getBindingNames() throws Exception {
        this.clearIO();
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.address);
            String[] bindingNames = new String[bindings.getBindings().size()];
            int i = 0;
            for (Binding binding : bindings.getBindings()) {
                bindingNames[i++] = binding.getUniqueName().toString();
            }
            String[] stringArray = bindingNames;
            return stringArray;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getRoles() throws Exception {
        this.clearIO();
        try {
            Set<Role> roles = this.securityRepository.getMatch(this.address.toString());
            Object[] objRoles = new Object[roles.size()];
            int i = 0;
            for (Role role : roles) {
                objRoles[i++] = new Object[]{role.getName(), CheckType.SEND.hasRole(role), CheckType.CONSUME.hasRole(role), CheckType.CREATE_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_DURABLE_QUEUE.hasRole(role), CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), CheckType.MANAGE.hasRole(role)};
            }
            Object[] objectArray = objRoles;
            return objectArray;
        }
        finally {
            this.blockOnIO();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRolesAsJSON() throws Exception {
        this.clearIO();
        try {
            JSONArray json = new JSONArray();
            Set<Role> roles = this.securityRepository.getMatch(this.address.toString());
            for (Role role : roles) {
                json.put(new JSONObject(role));
            }
            String string = json.toString();
            return string;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getNumberOfBytesPerPage() throws Exception {
        this.clearIO();
        try {
            long l = this.pagingManager.getPageStore(this.address).getPageSizeBytes();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getAddressSize() throws Exception {
        this.clearIO();
        try {
            long l = this.pagingManager.getPageStore(this.address).getAddressSize();
            return l;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public long getNumberOfMessages() throws Exception {
        this.clearIO();
        long totalMsgs = 0L;
        try {
            Bindings bindings = this.postOffice.getBindingsForAddress(this.address);
            ArrayList queueNames = new ArrayList();
            for (Binding binding : bindings.getBindings()) {
                if (!(binding instanceof QueueBinding)) continue;
                totalMsgs += ((QueueBinding)binding).getQueue().getMessageCount();
            }
            long l = totalMsgs;
            return l;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t.getMessage());
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public boolean isPaging() throws Exception {
        this.clearIO();
        try {
            boolean bl = this.pagingManager.getPageStore(this.address).isPaging();
            return bl;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    public int getNumberOfPages() throws Exception {
        this.clearIO();
        try {
            PagingStore pageStore = this.pagingManager.getPageStore(this.address);
            if (!pageStore.isPaging()) {
                int n = 0;
                return n;
            }
            int n = this.pagingManager.getPageStore(this.address).getNumberOfPages();
            return n;
        }
        finally {
            this.blockOnIO();
        }
    }

    @Override
    protected MBeanOperationInfo[] fillMBeanOperationInfo() {
        return MBeanInfoHelper.getMBeanOperationsInfo(AddressControl.class);
    }
}

