/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.remote.RemoteConnection;

@MessageLogger(projectCode="JBREM")
interface RemoteLogger
extends BasicLogger {
    public static final RemoteLogger log = Logger.getMessageLogger(RemoteLogger.class, "org.jboss.remoting.remote");
    public static final RemoteLogger conn = Logger.getMessageLogger(RemoteLogger.class, "org.jboss.remoting.remote.connection");
    public static final RemoteLogger server = Logger.getMessageLogger(RemoteLogger.class, "org.jboss.remoting.remote.server");
    public static final RemoteLogger client = Logger.getMessageLogger(RemoteLogger.class, "org.jboss.remoting.remote.client");

    @Message(id=200, value="Remote connection failed: %s")
    @LogMessage(level=Logger.Level.DEBUG)
    public void connectionError(IOException var1);

    @Message(id=201, value="Received invalid message on %s")
    public IOException invalidMessage(RemoteConnection var1);

    @Message(id=202, value="Abrupt close on %s")
    public IOException abruptClose(RemoteConnection var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=203, value="Message missing protocol byte")
    public void bufferUnderflowRaw();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=204, value="Buffer underflow parsing message with protocol ID %02x")
    public void bufferUnderflow(int var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=205, value="Failed to accept a connection: %s")
    public void failedToAccept(IOException var1);

    @Message(id=206, value="Channel is not open")
    public NotOpenException channelNotOpen();

    @Message(id=207, value="Failed to send a message (channel is busy)")
    public ChannelBusyException channelBusy();

    @Message(id=208, value="Write operation interrupted")
    public InterruptedIOException writeInterrupted();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=209, value="An exception occurred in a message handler")
    public void exceptionInUserHandler(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.FATAL)
    @Message(id=210, value="Internal Error: received a message with duplicate ID %d from %s")
    public void duplicateMessageId(short var1, SocketAddress var2);

    @Message(value="Internal Error: received a message with a duplicate ID")
    public IOException duplicateMessageIdException();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Message with unknown protocol ID %d received")
    public void unknownProtocolId(int var1);
}

