/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.lang.invoke.MethodHandles;
import org.infinispan.Cache;
import org.infinispan.server.websocket.json.JsonConversionException;
import org.infinispan.server.websocket.json.JsonObject;
import org.infinispan.server.websocket.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ChannelUtils {
    private static final Log logger = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);

    public static void pushCacheValue(String key, Cache<Object, Object> cache, ChannelHandlerContext ctx) {
        Object value = cache.get((Object)key);
        JsonObject responseObject = ChannelUtils.toJSON(key, value, cache.getName());
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(responseObject.toString()));
    }

    public static void pushErrorMessage(String errorMessage, ChannelHandlerContext ctx) {
        JsonObject errorObject = JsonObject.createNew();
        errorObject.put("error", (Object)errorMessage);
        ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(errorObject.toString()));
    }

    public static JsonObject toJSON(String key, Object value, String cacheName) {
        JsonObject jsonObject = JsonObject.createNew();
        jsonObject.put("cacheName", (Object)cacheName);
        jsonObject.put("key", (Object)key);
        if (value != null) {
            if (ChannelUtils.needsJsonConversion(value)) {
                JsonObject valueObject = ChannelUtils.getJsonObject(value);
                jsonObject.put("value", (Object)valueObject.toString());
                jsonObject.put("mime", (Object)"application/json");
            } else {
                jsonObject.put("value", value);
                jsonObject.put("mime", (Object)"text/plain");
            }
        } else {
            jsonObject.put("value", (Object)null);
        }
        return jsonObject;
    }

    private static JsonObject getJsonObject(Object value) {
        JsonObject valueObject;
        try {
            valueObject = JsonObject.fromObject(value);
        }
        catch (JsonConversionException e) {
            throw logger.unableToGetFieldsFromObject(e);
        }
        return valueObject;
    }

    private static boolean needsJsonConversion(Object value) {
        if (value instanceof String) {
            return false;
        }
        if (value instanceof Number) {
            return false;
        }
        return !(value instanceof Character);
    }
}

