/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingEntryCacheSet;
import org.infinispan.stream.impl.interceptor.AbstractDelegatingKeyCacheSet;
import org.infinispan.stream.impl.spliterators.IteratorAsSpliterator;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoverableTransactionIdentifier;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor<K, V>
extends CommandInterceptor
implements JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(TxInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    private RpcManager rpcManager;
    private CommandsFactory commandsFactory;
    private Cache<K, V> cache;
    private RecoveryManager recoveryManager;
    private TransactionTable txTable;
    private PartitionHandlingManager partitionHandlingManager;
    private boolean isTotalOrder;
    private boolean useOnePhaseForAutoCommitTx;
    private boolean useVersioning;
    private boolean statisticsEnabled;

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(TransactionTable txTable, Configuration configuration, RpcManager rpcManager, RecoveryManager recoveryManager, CommandsFactory commandsFactory, Cache<K, V> cache, PartitionHandlingManager partitionHandlingManager) {
        this.cacheConfiguration = configuration;
        this.txTable = txTable;
        this.rpcManager = rpcManager;
        this.recoveryManager = recoveryManager;
        this.commandsFactory = commandsFactory;
        this.cache = cache;
        this.partitionHandlingManager = partitionHandlingManager;
        this.statisticsEnabled = this.cacheConfiguration.jmxStatistics().enabled();
        this.isTotalOrder = configuration.transaction().transactionProtocol().isTotalOrder();
        this.useOnePhaseForAutoCommitTx = this.cacheConfiguration.transaction().use1PcForAutoCommitTransactions();
        this.useVersioning = Configurations.isVersioningEnabled(configuration);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        ((AbstractCacheTransaction)ctx.getCacheTransaction()).freezeModifications();
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        if (!ctx.isOriginLocal()) {
            ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
        } else if (((AbstractCacheTransaction)ctx.getCacheTransaction()).hasModification(ClearCommand.class)) {
            throw new IllegalStateException("No ClearCommand is allowed in Transaction.");
        }
        Object result = this.invokeNextInterceptorAndVerifyTransaction(ctx, command);
        if (!ctx.isOriginLocal()) {
            if (command.isOnePhaseCommit()) {
                this.txTable.remoteTransactionCommitted(command.getGlobalTransaction(), true);
            } else {
                this.txTable.remoteTransactionPrepared(command.getGlobalTransaction());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeNextInterceptorAndVerifyTransaction(TxInvocationContext ctx, AbstractTransactionBoundaryCommand command) throws Throwable {
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (!ctx.isOriginLocal()) {
                this.verifyRemoteTransaction((RemoteTxInvocationContext)ctx, command);
            }
        }
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (!ctx.isOriginLocal()) {
            if (this.txTable.isTransactionCompleted(gtx)) {
                if (trace) {
                    log.tracef("Transaction %s already completed, skipping commit", gtx);
                }
                return null;
            }
            if (!this.isTotalOrder) {
                this.replayRemoteTransactionIfNeeded((RemoteTxInvocationContext)ctx, command.getTopologyId());
            }
        }
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        if (!ctx.isOriginLocal() || this.isTotalOrder) {
            this.txTable.remoteTransactionCommitted(gtx, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        if (!ctx.isOriginLocal() || this.isTotalOrder) {
            this.txTable.remoteTransactionRollback(command.getGlobalTransaction());
        }
        try {
            Object object = this.invokeNextInterceptor(ctx, command);
            return object;
        }
        finally {
            if (this.recoveryManager != null) {
                GlobalTransaction gtx = command.getGlobalTransaction();
                this.recoveryManager.removeRecoveryInformation(((RecoverableTransactionIdentifier)((Object)gtx)).getXid());
            }
        }
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        if (ctx.isOriginLocal()) {
            command.setGlobalTransaction(ctx.getGlobalTransaction());
        }
        return this.invokeNextInterceptorAndVerifyTransaction(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitApplyDeltaCommand(InvocationContext ctx, ApplyDeltaCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public CacheSet<K> visitKeySetCommand(final InvocationContext ctx, KeySetCommand command) throws Throwable {
        CacheSet set = (CacheSet)this.enlistReadAndInvokeNext(ctx, command);
        if (ctx.isInTxScope()) {
            return new AbstractDelegatingKeyCacheSet(this.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<K> iterator() {
                    return new TransactionAwareKeyCloseableIterator(super.iterator(), (TxInvocationContext)ctx, TxInterceptor.this.cache);
                }

                @Override
                public CloseableSpliterator<K> spliterator() {
                    CloseableSpliterator parentSpliterator = super.spliterator();
                    long estimateSize = parentSpliterator.estimateSize() + (long)ctx.getLookedUpEntries().size();
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(estimateSize < 0L ? Long.MAX_VALUE : estimateSize).setCharacteristics(4353).get();
                }

                @Override
                public int size() {
                    long size = this.stream().count();
                    if (size > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)size;
                }
            };
        }
        return set;
    }

    @Override
    public CacheSet<CacheEntry<K, V>> visitEntrySetCommand(final InvocationContext ctx, EntrySetCommand command) throws Throwable {
        CacheSet set = (CacheSet)this.enlistReadAndInvokeNext(ctx, command);
        if (ctx.isInTxScope()) {
            return new AbstractDelegatingEntryCacheSet<K, V>(this.getCacheWithFlags(this.cache, command), set){

                @Override
                public CloseableIterator<CacheEntry<K, V>> iterator() {
                    return new TransactionAwareEntryCloseableIterator(super.iterator(), (TxInvocationContext)ctx, TxInterceptor.this.cache);
                }

                @Override
                public CloseableSpliterator<CacheEntry<K, V>> spliterator() {
                    CloseableSpliterator parentSpliterator = super.spliterator();
                    long estimateSize = parentSpliterator.estimateSize() + (long)ctx.getLookedUpEntries().size();
                    return new IteratorAsSpliterator.Builder(this.iterator()).setEstimateRemaining(estimateSize < 0L ? Long.MAX_VALUE : estimateSize).setCharacteristics(4353).get();
                }

                @Override
                public int size() {
                    long size = this.stream().count();
                    if (size > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)size;
                }
            };
        }
        return set;
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.enlistWriteAndInvokeNext(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.enlistReadAndInvokeNext(ctx, command);
    }

    private Object enlistReadAndInvokeNext(InvocationContext ctx, VisitableCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNextInterceptor(ctx, command);
    }

    private void enlistIfNeeded(InvocationContext ctx) throws SystemException {
        if (TxInterceptor.shouldEnlist(ctx)) {
            this.enlist((TxInvocationContext)ctx);
        }
    }

    private Object enlistWriteAndInvokeNext(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object rv;
        LocalTransaction localTransaction = null;
        if (TxInterceptor.shouldEnlist(ctx)) {
            boolean implicitWith1Pc;
            localTransaction = this.enlist((TxInvocationContext)ctx);
            boolean bl = implicitWith1Pc = this.useOnePhaseForAutoCommitTx && localTransaction.isImplicitTransaction();
            if (implicitWith1Pc) {
                command.addFlag(Flag.SKIP_LOCKING);
            }
        }
        try {
            rv = this.invokeNextInterceptor(ctx, command);
        }
        catch (OutdatedTopologyException e) {
            throw e;
        }
        catch (Throwable throwable) {
            if (ctx.isOriginLocal() && ctx.isInTxScope() && !command.hasFlag(Flag.FAIL_SILENTLY)) {
                TxInvocationContext txCtx = (TxInvocationContext)ctx;
                txCtx.getTransaction().setRollbackOnly();
            }
            throw throwable;
        }
        if (localTransaction != null && command.isSuccessful()) {
            localTransaction.addModification(command);
        }
        return rv;
    }

    public LocalTransaction enlist(TxInvocationContext ctx) throws SystemException {
        Transaction transaction = ctx.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        int status = transaction.getStatus();
        LocalTransaction localTransaction = this.txTable.getLocalTransaction(transaction);
        if (this.isNotValid(status)) {
            if (!localTransaction.isEnlisted()) {
                this.txTable.removeLocalTransaction(localTransaction);
            }
            throw new IllegalStateException("Transaction " + transaction + " is not in a valid state to be invoking cache operations on.");
        }
        this.txTable.enlist(transaction, localTransaction);
        return localTransaction;
    }

    private boolean isNotValid(int status) {
        return status != 0 && status != 7 && status != 8;
    }

    private static boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Number of transaction prepares performed since last reset", displayName="Prepares", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="Number of transaction commits performed since last reset", displayName="Commits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="Number of transaction rollbacks performed since last reset", displayName="Rollbacks", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRollbacks() {
        return this.rollbacks.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRemoteTransaction(RemoteTxInvocationContext ctx, AbstractTransactionBoundaryCommand command) throws Throwable {
        boolean canRollback;
        GlobalTransaction globalTransaction = command.getGlobalTransaction();
        Address origin = globalTransaction.getAddress();
        boolean originatorMissing = !this.rpcManager.getTransport().getMembers().contains(origin);
        boolean alreadyCompleted = this.txTable.isTransactionCompleted(globalTransaction) || !this.txTable.containRemoteTx(globalTransaction);
        boolean completedSuccessfully = alreadyCompleted && !((RemoteTransaction)ctx.getCacheTransaction()).isMarkedForRollback();
        boolean bl = canRollback = command instanceof PrepareCommand && !((PrepareCommand)command).isOnePhaseCommit() || command instanceof RollbackCommand || command instanceof LockControlCommand;
        if (trace) {
            log.tracef("invokeNextInterceptorAndVerifyTransaction :: originatorMissing=%s, alreadyCompleted=%s", originatorMissing, alreadyCompleted);
        }
        if (alreadyCompleted || originatorMissing && (canRollback || this.partitionHandlingManager.canRollbackTransactionAfterOriginatorLeave(globalTransaction))) {
            if (trace) {
                log.tracef("Rolling back remote transaction %s because either already completed (%s) or originator no longer in the cluster (%s).", globalTransaction, alreadyCompleted, originatorMissing);
            }
            RollbackCommand rollback = this.commandsFactory.buildRollbackCommand(command.getGlobalTransaction());
            try {
                this.invokeNextInterceptor(ctx, rollback);
            }
            finally {
                RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
                remoteTx.markForRollback(true);
                this.txTable.removeRemoteTransaction(globalTransaction);
            }
            if (originatorMissing && !completedSuccessfully) {
                throw log.orphanTransactionRolledBack(globalTransaction);
            }
        }
    }

    private void replayRemoteTransactionIfNeeded(RemoteTxInvocationContext ctx, int topologyId) throws Throwable {
        RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
        if (trace) {
            log.tracef("Remote tx topology id %d and command topology is %d", remoteTx.lookedUpEntriesTopology(), topologyId);
        }
        if (remoteTx.lookedUpEntriesTopology() < topologyId) {
            PrepareCommand prepareCommand = this.useVersioning ? this.commandsFactory.buildVersionedPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false) : this.commandsFactory.buildPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false);
            this.commandsFactory.initializeReplicableCommand(prepareCommand, true);
            prepareCommand.setOrigin(ctx.getOrigin());
            if (trace) {
                log.tracef("Replaying the transactions received as a result of state transfer %s", prepareCommand);
            }
            this.visitPrepareCommand(ctx, prepareCommand);
        }
    }

    static abstract class TransactionAwareCloseableIterator<E, K, V>
    implements CloseableIterator<E> {
        private final TxInvocationContext<LocalTransaction> ctx;
        private final List<CacheEntry> contextEntries;
        private final Set<Object> seenContextKeys = new HashSet<Object>();
        private final CloseableIterator<E> realIterator;
        protected E previousValue;
        protected E currentValue;

        public TransactionAwareCloseableIterator(CloseableIterator<E> realIterator, TxInvocationContext<LocalTransaction> ctx) {
            this.realIterator = realIterator;
            this.ctx = ctx;
            this.contextEntries = new ArrayList<CacheEntry>(ctx.getLookedUpEntries().values());
        }

        public boolean hasNext() {
            if (this.currentValue == null) {
                this.currentValue = this.getNextFromIterator();
            }
            return this.currentValue != null;
        }

        public E next() {
            E e;
            E e2 = e = this.currentValue == null ? this.getNextFromIterator() : this.currentValue;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.previousValue = e;
            this.currentValue = null;
            return e;
        }

        public void close() {
            this.realIterator.close();
        }

        protected abstract E fromEntry(CacheEntry<K, V> var1);

        protected abstract Object getKey(E var1);

        protected E getNextFromIterator() {
            CacheEntry entry;
            E returnedValue = null;
            while (returnedValue == null && !this.contextEntries.isEmpty() && (entry = this.contextEntries.remove(0)) != null) {
                this.seenContextKeys.add(entry.getKey());
                if (this.ctx.isEntryRemovedInContext(entry.getKey()) || entry.isNull()) continue;
                returnedValue = this.fromEntry(entry);
            }
            if (returnedValue == null) {
                while (this.realIterator.hasNext()) {
                    Object iteratedEntry = this.realIterator.next();
                    Object key = this.getKey(iteratedEntry);
                    CacheEntry contextEntry = this.ctx.lookupEntry(key);
                    if (contextEntry != null) {
                        if (!this.seenContextKeys.add(contextEntry.getKey()) || contextEntry.isRemoved() || contextEntry.isNull()) continue;
                        break;
                    }
                    this.seenContextKeys.add(key);
                    return (E)iteratedEntry;
                }
            }
            if (returnedValue == null) {
                for (CacheEntry lookedUpEntry : this.ctx.getLookedUpEntries().values()) {
                    if (!this.seenContextKeys.add(lookedUpEntry.getKey()) || lookedUpEntry.isRemoved() || lookedUpEntry.isNull()) continue;
                    if (returnedValue == null) {
                        returnedValue = this.fromEntry(lookedUpEntry);
                        continue;
                    }
                    this.contextEntries.add(lookedUpEntry);
                }
            }
            return returnedValue;
        }
    }

    static class TransactionAwareEntryCloseableIterator<K, V>
    extends TransactionAwareCloseableIterator<CacheEntry<K, V>, K, V> {
        private final Cache<K, V> cache;

        public TransactionAwareEntryCloseableIterator(CloseableIterator<CacheEntry<K, V>> realIterator, TxInvocationContext<LocalTransaction> ctx, Cache<K, V> cache) {
            super(realIterator, ctx);
            this.cache = cache;
        }

        public void remove() {
            if (this.previousValue == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(((CacheEntry)this.previousValue).getKey(), ((CacheEntry)this.previousValue).getValue());
            this.previousValue = null;
        }

        @Override
        protected CacheEntry<K, V> fromEntry(CacheEntry<K, V> entry) {
            return entry;
        }

        @Override
        protected Object getKey(CacheEntry<K, V> value) {
            return value.getKey();
        }
    }

    static class TransactionAwareKeyCloseableIterator<K, V>
    extends TransactionAwareCloseableIterator<K, K, V> {
        private final Cache<K, V> cache;

        public TransactionAwareKeyCloseableIterator(CloseableIterator<K> realIterator, TxInvocationContext<LocalTransaction> ctx, Cache<K, V> cache) {
            super(realIterator, ctx);
            this.cache = cache;
        }

        @Override
        protected K fromEntry(CacheEntry<K, V> entry) {
            return entry.getKey();
        }

        @Override
        protected Object getKey(K value) {
            return value;
        }

        public void remove() {
            if (this.previousValue == null) {
                throw new IllegalStateException();
            }
            this.cache.remove(this.previousValue);
            this.previousValue = null;
        }
    }
}

