/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.context;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.Util;

public enum Flag {
    ZERO_LOCK_ACQUISITION_TIMEOUT,
    CACHE_MODE_LOCAL,
    SKIP_LOCKING,
    FORCE_WRITE_LOCK,
    SKIP_CACHE_STATUS_CHECK,
    FORCE_ASYNCHRONOUS,
    FORCE_SYNCHRONOUS,
    SKIP_CACHE_STORE,
    SKIP_CACHE_LOAD,
    FAIL_SILENTLY,
    SKIP_REMOTE_LOOKUP,
    SKIP_INDEXING,
    PUT_FOR_EXTERNAL_READ,
    PUT_FOR_STATE_TRANSFER,
    PUT_FOR_X_SITE_STATE_TRANSFER,
    SKIP_SHARED_CACHE_STORE,
    REMOVE_DATA_ON_STOP,
    SKIP_OWNERSHIP_CHECK,
    DELTA_WRITE,
    IGNORE_RETURN_VALUES,
    SKIP_XSITE_BACKUP,
    GUARANTEED_DELIVERY,
    SKIP_LISTENER_NOTIFICATION,
    SKIP_STATISTICS,
    OPERATION_HOTROD,
    OPERATION_MEMCACHED,
    SKIP_INDEX_CLEANUP,
    COMMAND_RETRY;

    private static final Flag[] CACHED_VALUES;

    public static Set<Flag> copyWithoutRemotableFlags(Set<Flag> flags) {
        if (flags != null && flags.contains((Object)FAIL_SILENTLY)) {
            EnumSet<Flag> copy = EnumSet.copyOf(flags);
            copy.remove((Object)FAIL_SILENTLY);
            if (copy.isEmpty()) {
                return InfinispanCollections.emptySet();
            }
            return copy;
        }
        return flags;
    }

    public static Set<Flag> addFlag(Set<Flag> flags, Flag newFlag) {
        if (flags == null || flags.isEmpty()) {
            return EnumSet.of(newFlag);
        }
        if (flags.contains((Object)newFlag)) {
            return flags;
        }
        EnumSet<Flag> copy = EnumSet.copyOf(flags);
        copy.add(newFlag);
        return copy;
    }

    public static Set<Flag> addFlags(Set<Flag> flags, Flag ... newFlags) {
        if (newFlags == null || newFlags.length == 0) {
            return flags;
        }
        EnumSet<Flag> copy = flags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(flags);
        Collections.addAll(copy, newFlags);
        return copy;
    }

    public static Set<Flag> addFlags(Set<Flag> flags, Set<Flag> newFlags) {
        if (newFlags == null || newFlags.isEmpty()) {
            return flags;
        }
        if (flags == null || flags.isEmpty()) {
            return newFlags;
        }
        EnumSet<Flag> copy = EnumSet.copyOf(flags);
        copy.addAll(newFlags);
        return copy;
    }

    private static Flag valueOf(int ordinal) {
        return CACHED_VALUES[ordinal];
    }

    static {
        CACHED_VALUES = Flag.values();
    }

    public static class Externalizer
    extends AbstractExternalizer<Flag> {
        public Integer getId() {
            return 85;
        }

        public Set<Class<? extends Flag>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{Flag.class});
        }

        public void writeObject(ObjectOutput output, Flag flag) throws IOException {
            MarshallUtil.marshallEnum((Enum)flag, (ObjectOutput)output);
        }

        public Flag readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return (Flag)MarshallUtil.unmarshallEnum((ObjectInput)input, x$0 -> Flag.valueOf(x$0));
        }
    }
}

