/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.group;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.group.Group;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.remoting.transport.Address;

public class GroupManagerImpl
implements GroupManager {
    private final ConcurrentMap<Class<?>, GroupMetadata> groupMetadataCache = CollectionFactory.makeConcurrentMap();
    private final List<Grouper<?>> groupers;
    private ClusteringDependentLogic clusteringDependentLogic;

    private static GroupMetadata createGroupMetadata(Class<?> clazz) {
        Collection possibleMethods = System.getSecurityManager() == null ? ReflectionUtil.getAllMethods(clazz, Group.class) : (Collection)AccessController.doPrivileged(() -> ReflectionUtil.getAllMethods((Class)clazz, Group.class));
        if (possibleMethods.isEmpty()) {
            return GroupMetadata.NONE;
        }
        if (possibleMethods.size() == 1) {
            return new GroupMetadataImpl((Method)possibleMethods.iterator().next());
        }
        throw new IllegalStateException(Util.formatString((Object)"Cannot define more that one @Group method for class hierarchy rooted at %s", (Object[])new Object[]{clazz.getName()}));
    }

    public GroupManagerImpl(List<Grouper<?>> groupers) {
        this.groupers = groupers != null ? groupers : InfinispanCollections.emptyList();
    }

    @Inject
    public void injectDependencies(ClusteringDependentLogic clusteringDependentLogic) {
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    @Override
    public String getGroup(Object key) {
        GroupMetadata metadata = this.getMetadata(key);
        if (metadata != null) {
            return this.applyGroupers(metadata.getGroup(key), key);
        }
        return this.applyGroupers(null, key);
    }

    @Override
    public boolean isOwner(String group) {
        return this.clusteringDependentLogic.localNodeIsOwner(group);
    }

    @Override
    public Address getPrimaryOwner(String group) {
        return this.clusteringDependentLogic.getPrimaryOwner(group);
    }

    @Override
    public boolean isPrimaryOwner(String group) {
        return this.clusteringDependentLogic.localNodeIsPrimaryOwner(group);
    }

    private String applyGroupers(String group, Object key) {
        for (Grouper<?> grouper : this.groupers) {
            if (!grouper.getKeyType().isAssignableFrom(key.getClass())) continue;
            group = grouper.computeGroup(key, group);
        }
        return group;
    }

    private GroupMetadata getMetadata(Object key) {
        GroupMetadata previous;
        Class<?> keyClass = key.getClass();
        GroupMetadata groupMetadata = (GroupMetadata)this.groupMetadataCache.get(keyClass);
        if (groupMetadata == null && (previous = this.groupMetadataCache.putIfAbsent(keyClass, groupMetadata = GroupManagerImpl.createGroupMetadata(keyClass))) != null) {
            return previous;
        }
        return groupMetadata;
    }

    private static class GroupMetadataImpl
    implements GroupMetadata {
        private final Method method;

        public GroupMetadataImpl(Method method) {
            if (!String.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException(Util.formatString((Object)"@Group method %s must return java.lang.String", (Object[])new Object[]{method}));
            }
            if (method.getParameterTypes().length > 0) {
                throw new IllegalArgumentException(Util.formatString((Object)"@Group method %s must have zero arguments", (Object[])new Object[]{method}));
            }
            this.method = method;
        }

        @Override
        public String getGroup(Object instance) {
            Object object = System.getSecurityManager() == null ? ReflectionUtil.invokeAccessibly((Object)instance, (Method)this.method, (Object[])Util.EMPTY_OBJECT_ARRAY) : AccessController.doPrivileged(() -> ReflectionUtil.invokeAccessibly((Object)instance, (Method)this.method, (Object[])Util.EMPTY_OBJECT_ARRAY));
            return (String)String.class.cast(object);
        }
    }

    private static interface GroupMetadata {
        public static final GroupMetadata NONE = new GroupMetadata(){

            @Override
            public String getGroup(Object instance) {
                return null;
            }
        };

        public String getGroup(Object var1);
    }
}

