/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.List;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.UnsuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheTopologyControlCommand
implements ReplicableCommand {
    private static final Log log = LogFactory.getLog(CacheTopologyControlCommand.class);
    public static final byte COMMAND_ID = 17;
    private transient LocalTopologyManager localTopologyManager;
    private transient ClusterTopologyManager clusterTopologyManager;
    private String cacheName;
    private Type type;
    private Address sender;
    private CacheJoinInfo joinInfo;
    private int topologyId;
    private int rebalanceId;
    private ConsistentHash currentCH;
    private ConsistentHash pendingCH;
    private AvailabilityMode availabilityMode;
    private List<Address> actualMembers;
    private Throwable throwable;
    private int viewId;

    public CacheTopologyControlCommand() {
        this.cacheName = null;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheJoinInfo joinInfo, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.joinInfo = joinInfo;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, int topologyId, int rebalanceId, Throwable throwable, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.topologyId = topologyId;
        this.rebalanceId = rebalanceId;
        this.throwable = throwable;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, AvailabilityMode availabilityMode, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.availabilityMode = availabilityMode;
        this.viewId = viewId;
    }

    public CacheTopologyControlCommand(String cacheName, Type type, Address sender, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.topologyId = cacheTopology.getTopologyId();
        this.rebalanceId = cacheTopology.getRebalanceId();
        this.currentCH = cacheTopology.getCurrentCH();
        this.pendingCH = cacheTopology.getPendingCH();
        this.availabilityMode = availabilityMode;
        this.actualMembers = cacheTopology.getActualMembers();
        this.viewId = viewId;
    }

    @Inject
    public void init(LocalTopologyManager localTopologyManager, ClusterTopologyManager clusterTopologyManager) {
        this.localTopologyManager = localTopologyManager;
        this.clusterTopologyManager = clusterTopologyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            Object responseValue = this.doPerform();
            SuccessfulResponse successfulResponse = SuccessfulResponse.create(responseValue);
            return successfulResponse;
        }
        catch (InterruptedException e) {
            log.tracef("Command execution %s was interrupted because the cache manager is shutting down", this);
            UnsuccessfulResponse unsuccessfulResponse = UnsuccessfulResponse.INSTANCE;
            return unsuccessfulResponse;
        }
        catch (Exception t) {
            log.exceptionHandlingCommand(this, t);
            ExceptionResponse exceptionResponse = new ExceptionResponse(t);
            return exceptionResponse;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    private Object doPerform() throws Exception {
        switch (this.type) {
            case JOIN: {
                return this.clusterTopologyManager.handleJoin(this.cacheName, this.sender, this.joinInfo, this.viewId);
            }
            case LEAVE: {
                this.clusterTopologyManager.handleLeave(this.cacheName, this.sender, this.viewId);
                return null;
            }
            case REBALANCE_CONFIRM: {
                this.clusterTopologyManager.handleRebalanceCompleted(this.cacheName, this.sender, this.topologyId, this.throwable, this.viewId);
                return null;
            }
            case CH_UPDATE: {
                this.localTopologyManager.handleTopologyUpdate(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.actualMembers), this.availabilityMode, this.viewId, this.sender);
                return null;
            }
            case STABLE_TOPOLOGY_UPDATE: {
                this.localTopologyManager.handleStableTopologyUpdate(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.actualMembers), this.sender, this.viewId);
                return null;
            }
            case REBALANCE_START: {
                this.localTopologyManager.handleRebalance(this.cacheName, new CacheTopology(this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.actualMembers), this.viewId, this.sender);
                return null;
            }
            case GET_STATUS: {
                return this.localTopologyManager.handleStatusRequest(this.viewId);
            }
            case POLICY_GET_STATUS: {
                return this.clusterTopologyManager.isRebalancingEnabled(this.cacheName);
            }
            case POLICY_ENABLE: {
                this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, true);
                return true;
            }
            case POLICY_DISABLE: {
                this.clusterTopologyManager.setRebalancingEnabled(this.cacheName, false);
                return true;
            }
            case AVAILABILITY_MODE_CHANGE: {
                this.clusterTopologyManager.forceAvailabilityMode(this.cacheName, this.availabilityMode);
                return true;
            }
            case REBALANCING_GET_STATUS: {
                return this.clusterTopologyManager.getRebalancingStatus(this.cacheName);
            }
        }
        throw new CacheException("Unknown cache topology control command type " + (Object)((Object)this.type));
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public Address getOrigin() {
        return this.sender;
    }

    public Type getType() {
        return this.type;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public ConsistentHash getCurrentCH() {
        return this.currentCH;
    }

    public ConsistentHash getPendingCH() {
        return this.pendingCH;
    }

    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.cacheName, (byte)this.type.ordinal(), this.sender, this.joinInfo, this.topologyId, this.rebalanceId, this.currentCH, this.pendingCH, this.availabilityMode, this.actualMembers, this.throwable, this.viewId};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.cacheName = (String)parameters[i++];
        this.type = Type.CACHED_VALUES[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.joinInfo = (CacheJoinInfo)parameters[i++];
        this.topologyId = (Integer)parameters[i++];
        this.rebalanceId = (Integer)parameters[i++];
        this.currentCH = (ConsistentHash)parameters[i++];
        this.pendingCH = (ConsistentHash)parameters[i++];
        this.availabilityMode = (AvailabilityMode)((Object)parameters[i++]);
        this.actualMembers = (List)parameters[i++];
        this.throwable = (Throwable)parameters[i++];
        this.viewId = (Integer)parameters[i++];
    }

    public String toString() {
        return "CacheTopologyControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", joinInfo=" + this.joinInfo + ", topologyId=" + this.topologyId + ", rebalanceId=" + this.rebalanceId + ", currentCH=" + this.currentCH + ", pendingCH=" + this.pendingCH + ", availabilityMode=" + (Object)((Object)this.availabilityMode) + ", actualMembers=" + this.actualMembers + ", throwable=" + this.throwable + ", viewId=" + this.viewId + '}';
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public static enum Type {
        JOIN,
        LEAVE,
        REBALANCE_CONFIRM,
        CH_UPDATE,
        REBALANCE_START,
        GET_STATUS,
        STABLE_TOPOLOGY_UPDATE,
        POLICY_DISABLE,
        POLICY_ENABLE,
        POLICY_GET_STATUS,
        AVAILABILITY_MODE_CHANGE,
        REBALANCING_GET_STATUS;

        private static final Type[] CACHED_VALUES;

        static {
            CACHED_VALUES = Type.values();
        }
    }
}

