/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.events;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.security.Security;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;

public interface EventLogger {
    public void log(EventLogLevel var1, EventLogCategory var2, String var3);

    default public void info(EventLogCategory category, String message) {
        this.log(EventLogLevel.INFO, category, message);
    }

    default public void warn(EventLogCategory category, String message) {
        this.log(EventLogLevel.WARN, category, message);
    }

    default public void error(EventLogCategory category, String message) {
        this.log(EventLogLevel.ERROR, category, message);
    }

    default public void fatal(EventLogCategory category, String message) {
        this.log(EventLogLevel.FATAL, category, message);
    }

    default public EventLogger scope(String scope) {
        return this;
    }

    default public EventLogger context(Cache<?, ?> cache) {
        return this.context(cache.getName());
    }

    default public EventLogger context(String context) {
        return this;
    }

    default public EventLogger detail(String detail) {
        return this;
    }

    default public EventLogger detail(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(t.getLocalizedMessage());
        t.printStackTrace(pw);
        return this.detail(sw.toString());
    }

    default public EventLogger who(Subject subject) {
        if (subject != null) {
            return this.who(Security.getSubjectUserPrincipal(subject));
        }
        return this;
    }

    default public EventLogger who(Principal principal) {
        if (principal != null) {
            return this.who(principal.getName());
        }
        return this;
    }

    default public EventLogger who(String s) {
        return this;
    }

    public List<EventLog> getEvents(int var1, int var2);
}

