/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.eventlogger;

import java.util.List;
import java.util.UUID;
import org.infinispan.Cache;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.server.eventlogger.DecoratedServerEventLogger;
import org.infinispan.server.eventlogger.ServerEventImpl;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogger;

public class ServerEventLogger
implements EventLogger {
    public static final String EVENT_LOG_CACHE = "___event_log_cache";
    private final EmbeddedCacheManager cacheManager;
    private final TimeService timeService;
    private Cache<UUID, ServerEventImpl> eventCache;
    private QueryFactory<Query> queryFactory;

    ServerEventLogger(EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.timeService = timeService;
    }

    private Cache<UUID, ServerEventImpl> getEventCache() {
        if (this.eventCache == null) {
            this.eventCache = this.cacheManager.getCache(EVENT_LOG_CACHE);
        }
        return this.eventCache;
    }

    public void log(EventLogLevel level, EventLogCategory category, String message) {
        this.textLog(level, category, message);
        this.eventLog(new ServerEventImpl(level, category, this.timeService.instant(), message));
    }

    void textLog(EventLogLevel level, EventLogCategory category, String message) {
        LogFactory.getLogger((String)category.toString()).log(level.toLoggerLevel(), (Object)message);
    }

    void eventLog(ServerEventImpl event) {
        this.getEventCache().putAsync((Object)Util.threadLocalRandomUUID(), (Object)event);
    }

    public EventLogger scope(String scope) {
        return new DecoratedServerEventLogger(this).scope(scope);
    }

    public EventLogger context(String cacheName) {
        return new DecoratedServerEventLogger(this).context(cacheName);
    }

    public EventLogger detail(String detail) {
        return new DecoratedServerEventLogger(this).detail(detail);
    }

    public EventLogger who(String s) {
        return new DecoratedServerEventLogger(this).who(s);
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    public List<EventLog> getEvents(int start, int count) {
        Query query = this.getQueryFactory().from(ServerEventImpl.class).orderBy("when", SortOrder.DESC).maxResults(count).startOffset((long)start).build();
        return query.list();
    }

    private QueryFactory<Query> getQueryFactory() {
        if (this.queryFactory == null) {
            Cache cache = this.cacheManager.getCache(EVENT_LOG_CACHE);
            this.queryFactory = Search.getQueryFactory((Cache)cache);
        }
        return this.queryFactory;
    }
}

