/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import org.infinispan.objectfilter.impl.aggregation.DoubleStat;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

final class AvgAccumulator
extends FieldAccumulator {
    protected AvgAccumulator(int inPos, int outPos, Class<?> fieldType) {
        super(inPos, outPos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation AVG cannot be applied to property of type " + fieldType.getName());
        }
    }

    @Override
    public void init(Object[] accRow) {
        accRow[this.outPos] = new DoubleStat();
    }

    @Override
    public void update(Object[] accRow, Object value) {
        if (value != null) {
            ((DoubleStat)accRow[this.outPos]).update(((Number)value).doubleValue());
        }
    }

    @Override
    protected void merge(Object[] accRow, Object value) {
        if (value instanceof DoubleStat) {
            DoubleStat avgVal = (DoubleStat)value;
            if (avgVal.getCount() > 0L) {
                ((DoubleStat)accRow[this.outPos]).update(avgVal.getSum(), avgVal.getCount());
            }
        } else {
            this.update(accRow, value);
        }
    }

    @Override
    protected void finish(Object[] accRow) {
        accRow[this.outPos] = ((DoubleStat)accRow[this.outPos]).getAvg();
    }
}

