/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.service;

import com.sun.corba.se.impl.orb.ORBImpl;
import com.sun.corba.se.impl.orb.ORBSingleton;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.omg.CORBA.ORB;
import org.wildfly.iiop.openjdk.csiv2.CSIV2IORToSocketInfo;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.naming.jndi.CorbaUtils;
import org.wildfly.iiop.openjdk.service.CorbaServiceUtil;
import org.wildfly.iiop.openjdk.service.SecurityActions;
import org.wildfly.security.manager.WildFlySecurityManager;

public class CorbaORBService
implements Service<ORB> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"iiop-openjdk", "orb-service"});
    private static final Properties properties = new Properties();
    private final InjectedValue<ExecutorService> executorInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> iiopSocketBindingInjector = new InjectedValue();
    private final InjectedValue<SocketBinding> iiopSSLSocketBindingInjector = new InjectedValue();
    private volatile ORB orb;

    public CorbaORBService(Properties props) {
        if (props != null) {
            properties.putAll((Map<?, ?>)props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        if (IIOPLogger.ROOT_LOGGER.isDebugEnabled()) {
            IIOPLogger.ROOT_LOGGER.debugf("Starting service %s", context.getController().getName().getCanonicalName());
        }
        try {
            InetSocketAddress address;
            properties.setProperty("org.omg.CORBA.ORBClass", ORBImpl.class.getName());
            properties.setProperty("org.omg.CORBA.ORBSingletonClass", ORBSingleton.class.getName());
            WildFlySecurityManager.setPropertyPrivileged((String)"org.omg.CORBA.ORBClass", (String)ORBImpl.class.getName());
            WildFlySecurityManager.setPropertyPrivileged((String)"org.omg.CORBA.ORBSingletonClass", (String)ORBSingleton.class.getName());
            properties.setProperty("com.sun.CORBA.transport.ORBIORToSocketInfoClass", CSIV2IORToSocketInfo.class.getName());
            if (this.iiopSocketBindingInjector.getValue() != null) {
                address = ((SocketBinding)this.iiopSocketBindingInjector.getValue()).getSocketAddress();
                properties.setProperty("com.sun.CORBA.ORBServerHost", address.getAddress().getHostAddress());
                properties.setProperty("com.sun.CORBA.ORBServerPort", String.valueOf(address.getPort()));
                properties.setProperty("com.sun.CORBA.POA.ORBPersistentServerPort", String.valueOf(address.getPort()));
            }
            if (this.iiopSSLSocketBindingInjector.getValue() != null) {
                address = ((SocketBinding)this.iiopSSLSocketBindingInjector.getValue()).getSocketAddress();
                properties.setProperty("OASSLPort", String.valueOf(address.getPort()));
                String sslSocket = "SSL" + ':' + String.valueOf(address.getPort());
                properties.setProperty("com.sun.CORBA.transport.ORBListenSocket", sslSocket);
                if (!properties.containsKey("OAIAddr")) {
                    properties.setProperty("OAIAddr", address.getAddress().getHostAddress());
                }
            }
            ClassLoader loader = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()));
                this.orb = ORB.init((String[])new String[0], (Properties)properties);
                ORB.init();
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)loader);
            }
            Thread orbThread = SecurityActions.createThread(new ORBRunner(this.orb), "ORB Run Thread");
            orbThread.start();
            ServiceTarget target = context.getChildTarget();
            CorbaServiceUtil.bindObject(target, "ORB", this.orb);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        CorbaUtils.setOrbProperties(properties);
        IIOPLogger.ROOT_LOGGER.corbaORBServiceStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        if (IIOPLogger.ROOT_LOGGER.isDebugEnabled()) {
            IIOPLogger.ROOT_LOGGER.debugf("Stopping service %s", context.getController().getName().getCanonicalName());
        }
        ORBDestroyer destroyer = new ORBDestroyer(this.orb, context);
        try {
            ((ExecutorService)this.executorInjector.getValue()).execute(destroyer);
        }
        catch (RejectedExecutionException e) {
            destroyer.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public ORB getValue() throws IllegalStateException, IllegalArgumentException {
        return this.orb;
    }

    public Injector<SocketBinding> getIIOPSocketBindingInjector() {
        return this.iiopSocketBindingInjector;
    }

    public Injector<SocketBinding> getIIOPSSLSocketBindingInjector() {
        return this.iiopSSLSocketBindingInjector;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executorInjector;
    }

    public static String getORBProperty(String key) {
        return properties.getProperty(key);
    }

    public static ORB getCurrent() {
        return (ORB)CorbaORBService.currentServiceContainer().getRequiredService(SERVICE_NAME).getValue();
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    private class ORBDestroyer
    implements Runnable {
        private ORB orb;
        private StopContext context;

        public ORBDestroyer(ORB orb, StopContext context) {
            this.orb = orb;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                CorbaUtils.setOrbProperties(null);
                this.orb.destroy();
            }
            finally {
                this.context.complete();
            }
        }
    }

    private class ORBRunner
    implements Runnable {
        private ORB orb;

        public ORBRunner(ORB orb) {
            this.orb = orb;
        }

        @Override
        public void run() {
            this.orb.run();
        }
    }
}

