/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.filters;

import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.server.HttpHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.undertow.deployment.ConfiguredHandlerWrapper;
import org.wildfly.extension.undertow.filters.Filter;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class CustomFilterDefinition
extends Filter {
    public static final AttributeDefinition CLASS_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class-name", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).build();
    public static final AttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("module", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).build();
    public static final PropertiesAttributeDefinition PARAMETERS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("parameters", true).setAllowNull(true)).setWrapXmlElement(false).setXmlName("param").setAllowExpression(true)).setAttributeMarshaller(new AttributeMarshaller(){

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.isDefined() && resourceModel.hasDefined(attribute.getName());
        }

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (!resourceModel.hasDefined(attribute.getName())) {
                return;
            }
            resourceModel = resourceModel.get(attribute.getName());
            for (ModelNode property : resourceModel.asList()) {
                writer.writeEmptyElement(attribute.getXmlName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.asProperty().getName());
                writer.writeAttribute(Attribute.VALUE.getLocalName(), property.asProperty().getValue().asString());
            }
        }

        public void marshallAsAttribute(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            this.marshallAsElement(attribute, resourceModel, marshallDefault, writer);
        }

        public boolean isMarshallableAsElement() {
            return true;
        }
    })).build();
    public static final CustomFilterDefinition INSTANCE = new CustomFilterDefinition();

    private CustomFilterDefinition() {
        super("custom-filter");
    }

    @Override
    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(CLASS_NAME, MODULE, PARAMETERS);
    }

    @Override
    public HttpHandler createHttpHandler(Predicate predicate, ModelNode model, HttpHandler next) {
        String className = model.get(CLASS_NAME.getName()).asString();
        String moduleName = model.get(MODULE.getName()).asString();
        Map<String, String> params = this.unwrap(model);
        UndertowLogger.ROOT_LOGGER.debugf("Creating http handler %s from module %s with parameters %s", className, moduleName, params);
        Class<?> clazz = this.getHandlerClass(className, moduleName);
        ConfiguredHandlerWrapper wrapper = new ConfiguredHandlerWrapper(clazz, params);
        if (predicate != null) {
            return Handlers.predicate((Predicate)predicate, (HttpHandler)wrapper.wrap(next), (HttpHandler)next);
        }
        return wrapper.wrap(next);
    }

    @Override
    protected Class[] getConstructorSignature() {
        throw new IllegalStateException();
    }

    protected Class<?> getHandlerClass(String className, String moduleName) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        try {
            Module filterModule = moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
            return filterModule.getClassLoader().loadClassLocal(className);
        }
        catch (ClassNotFoundException | ModuleLoadException e) {
            throw UndertowLogger.ROOT_LOGGER.couldNotLoadHandlerFromModule(className, moduleName, (Exception)e);
        }
    }

    private Map<String, String> unwrap(ModelNode model) {
        if (!model.hasDefined(PARAMETERS.getName())) {
            return Collections.emptyMap();
        }
        ModelNode modelProps = model.get(PARAMETERS.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        for (Property p : modelProps.asPropertyList()) {
            props.put(p.getName(), p.getValue().asString());
        }
        return props;
    }
}

