/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.util.logging.LogFactory;

public class Option {
    private static final Log log = (Log)LogFactory.getLog(Option.class, Log.class);
    final String name;
    final String parameter;

    public Option(String name) {
        this(name, null);
    }

    public Option(String name, String parameter) {
        this.name = name;
        this.parameter = parameter;
    }

    public String getName() {
        return this.name;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String toString() {
        return this.name;
    }

    public <T extends Enum<T>> T toEnum(Class<T> enumType) throws StatementException {
        try {
            return Enum.valueOf(enumType, this.name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw log.unknownOption(this.name);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Option other = (Option)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

