/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.persistence;

import java.io.Serializable;
import java.util.Date;
import org.jboss.as.ejb3.timerservice.TimerImpl;
import org.jboss.as.ejb3.timerservice.TimerState;

public class TimerEntity
implements Serializable {
    protected final String id;
    protected final String timedObjectId;
    protected final Date initialDate;
    protected final long repeatInterval;
    protected final Date nextDate;
    protected final Date previousRun;
    protected final Serializable info;
    protected final Object primaryKey;
    protected final TimerState timerState;

    public TimerEntity(TimerImpl timer) {
        this.id = timer.getId();
        this.initialDate = timer.getInitialExpiration();
        this.repeatInterval = timer.getInterval();
        this.nextDate = timer.getNextExpiration();
        this.previousRun = timer.getPreviousRun();
        this.timedObjectId = timer.getTimedObjectId();
        this.info = timer.getTimerInfo();
        this.primaryKey = timer.getPrimaryKey();
        this.timerState = timer.getState() == TimerState.CREATED ? TimerState.ACTIVE : timer.getState();
    }

    public String getId() {
        return this.id;
    }

    public String getTimedObjectId() {
        return this.timedObjectId;
    }

    public Date getInitialDate() {
        return this.initialDate;
    }

    public long getInterval() {
        return this.repeatInterval;
    }

    public Serializable getInfo() {
        return this.info;
    }

    public Date getNextDate() {
        return this.nextDate;
    }

    public Date getPreviousRun() {
        return this.previousRun;
    }

    public TimerState getTimerState() {
        return this.timerState;
    }

    public boolean isCalendarTimer() {
        return false;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimerEntity)) {
            return false;
        }
        TimerEntity other = (TimerEntity)obj;
        if (this.id == null) {
            return false;
        }
        return this.id.equals(other.id);
    }

    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }
}

