/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.ParameterNameProvider;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.internal.cdi.DestructibleBeanInstance;
import org.hibernate.validator.internal.cdi.InjectingConstraintValidatorFactory;
import org.hibernate.validator.internal.cdi.ValidationProviderHelper;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.classhierarchy.ClassHierarchyHelper;
import org.hibernate.validator.internal.util.classhierarchy.Filter;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ValidatorFactoryBean
implements Bean<ValidatorFactory>,
PassivationCapable {
    private final BeanManager beanManager;
    private final Set<DestructibleBeanInstance<?>> destructibleResources;
    private final ValidationProviderHelper validationProviderHelper;
    private final Set<Type> types;

    public ValidatorFactoryBean(BeanManager beanManager, ValidationProviderHelper validationProviderHelper) {
        this.beanManager = beanManager;
        this.destructibleResources = CollectionHelper.newHashSet((int)4);
        this.validationProviderHelper = validationProviderHelper;
        this.types = Collections.unmodifiableSet(CollectionHelper.newHashSet((Collection)ClassHierarchyHelper.getHierarchy(validationProviderHelper.getValidatorFactoryBeanClass(), (Filter[])new Filter[0])));
    }

    public Class<?> getBeanClass() {
        return this.validationProviderHelper.getValidatorFactoryBeanClass();
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this.validationProviderHelper.getQualifiers();
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public ValidatorFactory create(CreationalContext<ValidatorFactory> ctx) {
        Configuration<?> config = this.getConfiguration();
        config.constraintValidatorFactory(this.createConstraintValidatorFactory(config));
        config.messageInterpolator(this.createMessageInterpolator(config));
        config.traversableResolver(this.createTraversableResolver(config));
        config.parameterNameProvider(this.createParameterNameProvider(config));
        return config.buildValidatorFactory();
    }

    public void destroy(ValidatorFactory instance, CreationalContext<ValidatorFactory> ctx) {
        for (DestructibleBeanInstance<?> resource : this.destructibleResources) {
            resource.destroy();
        }
        instance.close();
    }

    private MessageInterpolator createMessageInterpolator(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String messageInterpolatorFqcn = bootstrapConfiguration.getMessageInterpolatorClassName();
        if (messageInterpolatorFqcn == null) {
            return config.getDefaultMessageInterpolator();
        }
        Class messageInterpolatorClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)messageInterpolatorFqcn, null));
        return (MessageInterpolator)this.createInstance(messageInterpolatorClass);
    }

    private TraversableResolver createTraversableResolver(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String traversableResolverFqcn = bootstrapConfiguration.getTraversableResolverClassName();
        if (traversableResolverFqcn == null) {
            return config.getDefaultTraversableResolver();
        }
        Class traversableResolverClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)traversableResolverFqcn, null));
        return (TraversableResolver)this.createInstance(traversableResolverClass);
    }

    private ParameterNameProvider createParameterNameProvider(Configuration<?> config) {
        BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
        String parameterNameProviderFqcn = bootstrapConfiguration.getParameterNameProviderClassName();
        if (parameterNameProviderFqcn == null) {
            return config.getDefaultParameterNameProvider();
        }
        Class parameterNameProviderClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)parameterNameProviderFqcn, null));
        return (ParameterNameProvider)this.createInstance(parameterNameProviderClass);
    }

    private ConstraintValidatorFactory createConstraintValidatorFactory(Configuration<?> config) {
        BootstrapConfiguration configSource = config.getBootstrapConfiguration();
        String constraintValidatorFactoryFqcn = configSource.getConstraintValidatorFactoryClassName();
        if (constraintValidatorFactoryFqcn == null) {
            return this.createInstance(InjectingConstraintValidatorFactory.class);
        }
        Class constraintValidatorFactoryClass = (Class)this.run((PrivilegedAction)LoadClass.action((String)constraintValidatorFactoryFqcn, null));
        return (ConstraintValidatorFactory)this.createInstance(constraintValidatorFactoryClass);
    }

    private <T> T createInstance(Class<T> type) {
        DestructibleBeanInstance<T> destructibleInstance = new DestructibleBeanInstance<T>(this.beanManager, type);
        this.destructibleResources.add(destructibleInstance);
        return destructibleInstance.getInstance();
    }

    private Configuration<?> getConfiguration() {
        return this.validationProviderHelper.isDefaultProvider() ? Validation.byDefaultProvider().configure() : Validation.byProvider(HibernateValidator.class).configure();
    }

    private <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    public String getId() {
        return ValidatorFactoryBean.class.getName() + "_" + (this.validationProviderHelper.isDefaultProvider() ? "default" : "hv");
    }

    public String toString() {
        return "ValidatorFactoryBean [id=" + this.getId() + "]";
    }
}

