/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyEnhancedImpl;
import org.hibernate.property.access.spi.EnhancedGetterMethodImpl;
import org.hibernate.property.access.spi.EnhancedSetterMethodImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.GetterFieldImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessBuildingException;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.property.access.spi.SetterFieldImpl;

public class PropertyAccessEnhancedImpl
implements PropertyAccess {
    private final PropertyAccessStrategyEnhancedImpl strategy;
    private final Getter getter;
    private final Setter setter;

    public PropertyAccessEnhancedImpl(PropertyAccessStrategyEnhancedImpl strategy, Class containerJavaType, String propertyName) {
        Class<?> propertyJavaType;
        this.strategy = strategy;
        Field field = PropertyAccessEnhancedImpl.fieldOrNull(containerJavaType, propertyName);
        Method getterMethod = PropertyAccessEnhancedImpl.getterMethodOrNull(containerJavaType, propertyName);
        if (field == null && getterMethod == null) {
            String msg = String.format("Could not locate field nor getter method for property named [%s#%s]", containerJavaType.getName(), propertyName);
            throw new PropertyAccessBuildingException(msg);
        }
        if (field != null) {
            propertyJavaType = field.getType();
            this.getter = PropertyAccessEnhancedImpl.resolveGetterForField(containerJavaType, propertyName, field);
        } else {
            propertyJavaType = getterMethod.getReturnType();
            this.getter = new EnhancedGetterMethodImpl(containerJavaType, propertyName, getterMethod);
        }
        Method setterMethod = PropertyAccessEnhancedImpl.setterMethodOrNull(containerJavaType, propertyName, propertyJavaType);
        if (field == null && setterMethod == null) {
            String msg = String.format("Could not locate field nor getter method for property named [%s#%s]", containerJavaType.getName(), propertyName);
            throw new PropertyAccessBuildingException(msg);
        }
        this.setter = field != null ? PropertyAccessEnhancedImpl.resolveSetterForField(containerJavaType, propertyName, field) : new EnhancedSetterMethodImpl(containerJavaType, propertyName, setterMethod);
    }

    private static Field fieldOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findField(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method getterMethodOrNull(Class containerJavaType, String propertyName) {
        try {
            return ReflectHelper.findGetterMethod(containerJavaType, propertyName);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Method setterMethodOrNull(Class containerJavaType, String propertyName, Class propertyJavaType) {
        try {
            return ReflectHelper.findSetterMethod(containerJavaType, propertyName, propertyJavaType);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    private static Getter resolveGetterForField(Class<?> containerClass, String propertyName, Field field) {
        try {
            String enhancedGetterName = "$$_hibernate_read_" + propertyName;
            Method enhancedGetter = containerClass.getDeclaredMethod(enhancedGetterName, new Class[0]);
            enhancedGetter.setAccessible(true);
            return new EnhancedGetterMethodImpl(containerClass, propertyName, enhancedGetter);
        }
        catch (NoSuchMethodException e) {
            return new GetterFieldImpl(containerClass, propertyName, field);
        }
    }

    private static Setter resolveSetterForField(Class<?> containerClass, String propertyName, Field field) {
        try {
            String enhancedSetterName = "$$_hibernate_write_" + propertyName;
            Method enhancedSetter = containerClass.getDeclaredMethod(enhancedSetterName, field.getType());
            enhancedSetter.setAccessible(true);
            return new EnhancedSetterMethodImpl(containerClass, propertyName, enhancedSetter);
        }
        catch (NoSuchMethodException e) {
            return new SetterFieldImpl(containerClass, propertyName, field);
        }
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this.getter;
    }

    @Override
    public Setter getSetter() {
        return this.setter;
    }
}

