/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterFactory;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractNamedFactoryExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class FilterConverterFactoryExtensionProcessor
extends AbstractNamedFactoryExtensionProcessor<CacheEventFilterConverterFactory> {
    public FilterConverterFactoryExtensionProcessor(ServiceName extensionManagerServiceName) {
        super(extensionManagerServiceName);
    }

    @Override
    public AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventFilterConverterFactory> createService(String name, CacheEventFilterConverterFactory instance) {
        return new FilterConverterFactoryService(name, instance);
    }

    @Override
    public Class<CacheEventFilterConverterFactory> getServiceClass() {
        return CacheEventFilterConverterFactory.class;
    }

    private static class FilterConverterFactoryService
    extends AbstractNamedFactoryExtensionProcessor.AbstractExtensionManagerService<CacheEventFilterConverterFactory> {
        private FilterConverterFactoryService(String name, CacheEventFilterConverterFactory converterFactory) {
            super(name, converterFactory);
        }

        public void start(StartContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Started combined filter and converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).addFilterConverterFactory(this.name, (CacheEventFilterConverterFactory)this.extension);
        }

        public void stop(StopContext context) {
            EndpointLogger.ROOT_LOGGER.debugf("Stopped combined filter and converter service with name = %s", this.name);
            ((ExtensionManagerService)this.extensionManager.getValue()).removeFilterConverterFactory(this.name);
        }

        public CacheEventFilterConverterFactory getValue() {
            return (CacheEventFilterConverterFactory)this.extension;
        }

        @Override
        public String getServiceTypeName() {
            return "filter-converter-factory";
        }
    }
}

