/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import org.infinispan.server.endpoint.subsystem.EndpointUtils;
import org.infinispan.server.endpoint.subsystem.ProtocolServerConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestConnectorResource;
import org.infinispan.server.endpoint.subsystem.RestService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;

class RestSubsystemAdd
extends AbstractAddStepHandler {
    static final RestSubsystemAdd INSTANCE = new RestSubsystemAdd();

    RestSubsystemAdd() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode config = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        RestService service = new RestService(config);
        ServiceBuilder builder = context.getServiceTarget().addService(EndpointUtils.getServiceName(operation, "rest"), (Service)service);
        EndpointUtils.addCacheContainerDependency(builder, service.getCacheContainerName(), service.getCacheManager());
        EndpointUtils.addSocketBindingDependency(builder, this.getSocketBindingName(operation), service.getSocketBinding());
        builder.addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManagerInjector());
        if (service.getSecurityDomain() != null) {
            EndpointUtils.addSecurityDomainDependency(builder, service.getSecurityDomain(), service.getSecurityDomainContextInjector());
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }

    protected String getSocketBindingName(ModelNode config) {
        return config.hasDefined("socket-binding") ? config.get("socket-binding").asString() : null;
    }

    protected void populateModel(ModelNode source, ModelNode target) throws OperationFailedException {
        RestSubsystemAdd.populate(source, target);
    }

    private static void populate(ModelNode source, ModelNode target) throws OperationFailedException {
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : ProtocolServerConnectorResource.COMMON_LIST_CONNECTOR_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
        for (SimpleAttributeDefinition simpleAttributeDefinition : RestConnectorResource.REST_ATTRIBUTES) {
            simpleAttributeDefinition.validateAndSet(source, target);
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }
}

