/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.scripting.impl.ExecutionMode;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ScriptMetadataParser {
    private static final Log log = (Log)LogFactory.getLog(ScriptMetadataParser.class, Log.class);
    private static final String DEFAULT_SCRIPT_EXTENSION = "js";
    private static final Pattern METADATA_COMMENT = Pattern.compile("^(?:#|//|;;)\\s*(.+)");
    private static final Pattern METADATA_KV = Pattern.compile("\\s*(\\w+)\\s*=\\s*(\"[^\"]*\"|'[^']*'|\\[[\\w,\\s]*\\]|[^,=\\s\"]+)\\s*,?");

    public static ScriptMetadata parse(String name, String script) {
        ScriptMetadata.Builder metadataBuilder = new ScriptMetadata.Builder();
        metadataBuilder.name(name);
        metadataBuilder.mode(ExecutionMode.LOCAL);
        int s = name.lastIndexOf(".") + 1;
        if (s == 0 || s == name.length()) {
            metadataBuilder.extension(DEFAULT_SCRIPT_EXTENSION);
        } else {
            metadataBuilder.extension(name.substring(s));
        }
        try (BufferedReader r = new BufferedReader(new StringReader(script));){
            String line = r.readLine();
            while (line != null) {
                Matcher matcher = METADATA_COMMENT.matcher(line);
                if (!matcher.matches()) {
                    break;
                }
                String text = matcher.group(1);
                matcher = METADATA_KV.matcher(text);
                block34: while (matcher.find()) {
                    String key = matcher.group(1).toLowerCase();
                    String value = ScriptMetadataParser.unquote(matcher.group(2));
                    switch (key) {
                        case "name": {
                            metadataBuilder.name(value);
                            continue block34;
                        }
                        case "extension": {
                            metadataBuilder.extension(value);
                            continue block34;
                        }
                        case "language": {
                            metadataBuilder.language(value);
                            continue block34;
                        }
                        case "mode": {
                            metadataBuilder.mode(ExecutionMode.valueOf(value.toUpperCase()));
                            continue block34;
                        }
                        case "parameters": {
                            metadataBuilder.parameters(ScriptMetadataParser.unarray(value));
                            continue block34;
                        }
                        case "role": {
                            metadataBuilder.role(value);
                            continue block34;
                        }
                        case "reducer": {
                            metadataBuilder.reducer(value);
                            continue block34;
                        }
                        case "combiner": {
                            metadataBuilder.combiner(value);
                            continue block34;
                        }
                        case "collator": {
                            metadataBuilder.collator(value);
                            continue block34;
                        }
                    }
                    throw log.unknownScriptProperty(key);
                }
                line = r.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return metadataBuilder.build();
    }

    private static String unquote(String s) {
        if (s.charAt(0) == '\"' || s.charAt(0) == '\'') {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private static Set<String> unarray(String s) {
        if (s.charAt(0) == '[') {
            String[] ps = s.substring(1, s.length() - 1).split("\\s*,\\s*");
            HashSet<String> parameters = new HashSet<String>();
            for (String p : ps) {
                parameters.add(p);
            }
            return parameters;
        }
        throw log.parametersNotArray();
    }
}

