/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private final boolean mutable;
    private final boolean disableCoord;
    private int minimumNumberShouldMatch;
    private List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    private BooleanQuery(boolean disableCoord, int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.disableCoord = disableCoord;
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.mutable = false;
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.getOccur()).add(clause.getQuery());
        }
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    private BooleanQuery rewriteNoScoring() {
        Builder newQuery = new Builder();
        newQuery.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        for (BooleanClause clause : this.clauses) {
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                newQuery.add(clause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            newQuery.add(clause);
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        BooleanQuery query = this;
        if (!needsScores) {
            query = this.rewriteNoScoring();
        }
        return new BooleanWeight(query, searcher, needsScores, this.disableCoord);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanClause c;
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        if (this.minimumNumberShouldMatch == 0 && this.clauses.size() == 1 && !(c = this.clauses.get(0)).isProhibited()) {
            Query query = c.getQuery();
            if (!c.isScoring()) {
                query = new BoostQuery(new ConstantScoreQuery(query), 0.0f);
            }
            return query;
        }
        Builder builder = new Builder();
        builder.setDisableCoord(this.isCoordDisabled());
        builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause clause : this) {
            Query query = clause.getQuery();
            Query rewritten = query.rewrite(reader);
            if (rewritten != query) {
                actuallyRewritten = true;
            }
            builder.add(rewritten, clause.getOccur());
        }
        if (actuallyRewritten) {
            return builder.build();
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i = 0;
        for (BooleanClause c : this) {
            buffer.append(c.getOccur().toString());
            Query subQuery = c.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        BooleanQuery that = (BooleanQuery)o;
        if (this.getMinimumNumberShouldMatch() != that.getMinimumNumberShouldMatch()) {
            return false;
        }
        if (this.disableCoord != that.disableCoord) {
            return false;
        }
        if (this.mutable != that.mutable) {
            return false;
        }
        if (this.mutable) {
            return this.clauses.equals(that.clauses);
        }
        return this.clauseSets.equals(that.clauseSets);
    }

    private int computeHashCode() {
        int hashCode = Objects.hash(this.disableCoord, this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.mutable) {
            assert (this.clauseSets == null);
            return 31 * super.hashCode() + Objects.hash(this.disableCoord, this.minimumNumberShouldMatch, this.clauses);
        }
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return 31 * super.hashCode() + this.hashCode;
    }

    @Deprecated
    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    @Override
    public BooleanQuery clone() {
        BooleanQuery clone = (BooleanQuery)super.clone();
        clone.clauses = new ArrayList<BooleanClause>(this.clauses);
        return clone;
    }

    @Deprecated
    public BooleanQuery() {
        this(false);
    }

    @Deprecated
    public BooleanQuery(boolean disableCoord) {
        this.clauses = new ArrayList<BooleanClause>();
        this.disableCoord = disableCoord;
        this.minimumNumberShouldMatch = 0;
        this.mutable = true;
        this.clauseSets = null;
    }

    private void ensureMutable(String method) {
        if (!this.mutable) {
            throw new IllegalStateException("This BooleanQuery has been created with the new BooleanQuery.Builder API. It must not be modified afterwards. The " + method + " method only exists for backward compatibility");
        }
    }

    @Deprecated
    public void setMinimumNumberShouldMatch(int min) {
        this.ensureMutable("setMinimumNumberShouldMatch");
        this.minimumNumberShouldMatch = min;
    }

    @Deprecated
    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    @Deprecated
    public void add(BooleanClause clause) {
        this.ensureMutable("add");
        Objects.requireNonNull(clause, "BooleanClause must not be null");
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(clause);
    }

    public static class Builder {
        private boolean disableCoord;
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setDisableCoord(boolean disableCoord) {
            this.disableCoord = disableCoord;
            return this;
        }

        public Builder setMinimumNumberShouldMatch(int min) {
            this.minimumNumberShouldMatch = min;
            return this;
        }

        public Builder add(BooleanClause clause) {
            this.add(clause.getQuery(), clause.getOccur());
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            if (this.clauses.size() >= maxClauseCount) {
                throw new TooManyClauses();
            }
            this.clauses.add(new BooleanClause(query, occur));
            return this;
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.disableCoord, this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

