/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.server.session.SessionIdGenerator;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactory;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManager;
import org.wildfly.extension.undertow.security.sso.SingleSignOnManagerFactory;

public class DistributableSingleSignOnManagerFactory
implements SingleSignOnManagerFactory,
LocalContextFactory<Void> {
    private final SSOManagerFactory<AuthenticatedSessionManager.AuthenticatedSession, String, Batch> factory;
    private final SessionManagerRegistry registry;

    public DistributableSingleSignOnManagerFactory(SSOManagerFactory<AuthenticatedSessionManager.AuthenticatedSession, String, Batch> factory, SessionManagerRegistry registry) {
        this.factory = factory;
        this.registry = registry;
    }

    public SingleSignOnManager createSingleSignOnManager(Host host) {
        SecureRandomSessionIdGenerator sessionIdGenerator = new SecureRandomSessionIdGenerator();
        sessionIdGenerator.setLength(host.getServer().getServletContainer().getSessionIdLength());
        IdentifierFactoryAdapter identifierFactory = new IdentifierFactoryAdapter((SessionIdGenerator)sessionIdGenerator);
        SSOManager manager = this.factory.createSSOManager((IdentifierFactory)identifierFactory, (LocalContextFactory)this);
        return new DistributableSingleSignOnManager((SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, Void, Batch>)manager, this.registry);
    }

    public Void createLocalContext() {
        return null;
    }
}

