/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.continuous.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public final class ContinuousQueryResult<V> {
    private final boolean isJoining;
    private final V value;
    private final Object[] projection;

    public ContinuousQueryResult(boolean isJoining, V value, Object[] projection) {
        this.isJoining = isJoining;
        this.value = value;
        this.projection = projection;
    }

    public boolean isJoining() {
        return this.isJoining;
    }

    public V getValue() {
        return this.value;
    }

    public Object[] getProjection() {
        return this.projection;
    }

    public String toString() {
        return "ContinuousQueryResult{isJoining=" + this.isJoining + ", value=" + this.value + ", projection=" + Arrays.toString(this.projection) + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<ContinuousQueryResult> {
        public void writeObject(ObjectOutput output, ContinuousQueryResult continuousQueryResult) throws IOException {
            output.writeBoolean(continuousQueryResult.isJoining);
            if (continuousQueryResult.isJoining) {
                if (continuousQueryResult.projection != null) {
                    output.writeObject(null);
                    output.writeObject(continuousQueryResult.projection);
                } else {
                    output.writeObject(continuousQueryResult.value);
                }
            }
        }

        public ContinuousQueryResult readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            boolean isJoining = input.readBoolean();
            Object value = null;
            Object[] projection = null;
            if (isJoining && (value = input.readObject()) == null) {
                projection = (Object[])input.readObject();
            }
            return new ContinuousQueryResult<Object>(isJoining, value, projection);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_CONTINUOUS_QUERY_RESULT;
        }

        public Set<Class<? extends ContinuousQueryResult>> getTypeClasses() {
            return Collections.singleton(ContinuousQueryResult.class);
        }
    }
}

