/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQuery;

final class DelegatingQuery
extends BaseQuery {
    private final QueryEngine queryEngine;
    private BaseQuery query;

    DelegatingQuery(QueryEngine queryEngine, QueryFactory queryFactory, String jpaQuery, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, jpaQuery, namedParameters, projection, startOffset, maxResults);
        this.queryEngine = queryEngine;
    }

    public void resetQuery() {
        if (this.query != null) {
            this.query.resetQuery();
        }
    }

    private Query createQuery() {
        if (this.query == null) {
            this.query = this.queryEngine.buildQuery(this.queryFactory, this.jpaQuery, this.namedParameters, this.startOffset, this.maxResults);
        }
        return this.query;
    }

    public <T> List<T> list() {
        return this.createQuery().list();
    }

    public int getResultSize() {
        return this.createQuery().getResultSize();
    }

    public String toString() {
        return "DelegatingQuery{jpaQuery=" + this.jpaQuery + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

