/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.util.KeyValuePair;

public class JPAFilterAndConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, ObjectFilter.FilterResult> {
    private QueryCache queryCache;
    private final String jpaQuery;
    private final Map<String, Object> namedParameters;
    private final Class<? extends Matcher> matcherImplClass;
    private Matcher matcher;
    private ObjectFilter objectFilter;

    public JPAFilterAndConverter(String jpaQuery, Map<String, Object> namedParameters, Class<? extends Matcher> matcherImplClass) {
        if (jpaQuery == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.jpaQuery = jpaQuery;
        this.namedParameters = namedParameters;
        this.matcherImplClass = matcherImplClass;
    }

    @Inject
    public void injectDependencies(Cache cache) {
        this.queryCache = (QueryCache)cache.getCacheManager().getGlobalComponentRegistry().getComponent(QueryCache.class);
        this.matcher = (Matcher)cache.getAdvancedCache().getComponentRegistry().getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    public ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            if (this.queryCache != null && (this.namedParameters == null || this.namedParameters.isEmpty())) {
                KeyValuePair queryCacheKey = new KeyValuePair((Object)this.jpaQuery, this.matcherImplClass);
                ObjectFilter objectFilter = (ObjectFilter)this.queryCache.get(queryCacheKey);
                if (objectFilter == null) {
                    objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
                    this.queryCache.put(queryCacheKey, objectFilter);
                }
                this.objectFilter = objectFilter;
            } else {
                this.objectFilter = this.matcher.getObjectFilter(this.jpaQuery, this.namedParameters);
            }
        }
        return this.objectFilter;
    }

    public String getJPAQuery() {
        return this.jpaQuery;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public ObjectFilter.FilterResult filterAndConvert(K key, V value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(value);
    }

    public String toString() {
        return "JPAFilterAndConverter{jpaQuery='" + this.jpaQuery + "'}";
    }

    public static final class FilterResultExternalizer
    extends AbstractExternalizer<FilterResultImpl> {
        public void writeObject(ObjectOutput output, FilterResultImpl filterResult) throws IOException {
            if (filterResult.getProjection() != null) {
                output.writeObject(null);
                output.writeObject(filterResult.getProjection());
            } else {
                output.writeObject(filterResult.getInstance());
            }
            output.writeObject(filterResult.getSortProjection());
        }

        public FilterResultImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object instance = input.readObject();
            Object[] projection = instance == null ? (Object[])input.readObject() : null;
            Comparable[] sortProjection = (Comparable[])input.readObject();
            return new FilterResultImpl(instance, projection, sortProjection);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_FILTER_RESULT;
        }

        public Set<Class<? extends FilterResultImpl>> getTypeClasses() {
            return Collections.singleton(FilterResultImpl.class);
        }
    }

    public static final class JPAFilterAndConverterExternalizer
    extends AbstractExternalizer<JPAFilterAndConverter> {
        public void writeObject(ObjectOutput output, JPAFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.jpaQuery);
            Map namedParameters = filterAndConverter.namedParameters;
            if (namedParameters != null) {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)namedParameters.size());
                for (Map.Entry e : namedParameters.entrySet()) {
                    output.writeUTF((String)e.getKey());
                    output.writeObject(e.getValue());
                }
            } else {
                UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)0);
            }
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public JPAFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            int paramsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            HashMap<String, Object> namedParameters = null;
            if (paramsSize != 0) {
                namedParameters = new HashMap<String, Object>(paramsSize);
                for (int i = 0; i < paramsSize; ++i) {
                    String paramName = input.readUTF();
                    Object paramValue = input.readObject();
                    namedParameters.put(paramName, paramValue);
                }
            }
            Class matcherImplClass = (Class)input.readObject();
            return new JPAFilterAndConverter(jpaQuery, namedParameters, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends JPAFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(JPAFilterAndConverter.class);
        }
    }
}

