/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.cursor.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.LivePageCache;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

public class LivePageCacheImpl
implements LivePageCache {
    private final List<PagedMessage> messages = new LinkedList<PagedMessage>();
    private final Page page;
    private boolean isLive = true;

    public LivePageCacheImpl(Page page) {
        this.page = page;
    }

    @Override
    public long getPageId() {
        return this.page.getPageId();
    }

    @Override
    public synchronized int getNumberOfMessages() {
        return this.messages.size();
    }

    @Override
    public synchronized void setMessages(PagedMessage[] messages) {
        for (PagedMessage msg : messages) {
            this.addLiveMessage(msg);
        }
    }

    @Override
    public synchronized PagedMessage getMessage(int messageNumber) {
        if (messageNumber < this.messages.size()) {
            return this.messages.get(messageNumber);
        }
        return null;
    }

    @Override
    public synchronized boolean isLive() {
        return this.isLive;
    }

    @Override
    public synchronized void addLiveMessage(PagedMessage message) {
        if (message.getMessage().isLargeMessage()) {
            ((LargeServerMessage)message.getMessage()).incrementDelayDeletionCount();
        }
        this.messages.add(message);
    }

    @Override
    public synchronized void close() {
        this.isLive = false;
    }

    @Override
    public synchronized PagedMessage[] getMessages() {
        return this.messages.toArray(new PagedMessage[this.messages.size()]);
    }

    public String toString() {
        return "LivePacheCacheImpl::page=" + this.page.getPageId() + " number of messages=" + this.messages.size() + " isLive = " + this.isLive;
    }
}

