/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commands.AbstractFlagAffectedCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GetAllCommand
extends AbstractFlagAffectedCommand {
    public static final byte COMMAND_ID = 44;
    private static final Log log = LogFactory.getLog(GetAllCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private Collection<?> keys;
    private boolean returnEntries;
    private ConsistentHash ch;
    private Map<Object, InternalCacheEntry> remotelyFetched;
    private InternalEntryFactory entryFactory;

    public GetAllCommand(Collection<?> keys, Set<Flag> flags, boolean returnEntries, InternalEntryFactory entryFactory) {
        this.keys = keys;
        this.flags = flags;
        this.returnEntries = returnEntries;
        this.entryFactory = entryFactory;
    }

    GetAllCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetAllCommand(ctx, this);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return status != ComponentStatus.RUNNING && status != ComponentStatus.INITIALIZING;
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        Map map = this.createMap();
        for (Object key : this.keys) {
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry == null) {
                if (!trace) continue;
                log.tracef("Entry for key %s not found", key);
                continue;
            }
            if (entry.isNull()) {
                if (trace) {
                    log.tracef("Entry for key %s is null in current context", key);
                }
                map.put(key, null);
                continue;
            }
            if (entry.isRemoved()) {
                if (trace) {
                    log.tracef("Entry for key %s has been deleted and is of type %s", key, entry.getClass().getSimpleName());
                }
                map.put(key, null);
                continue;
            }
            if (this.returnEntries) {
                CacheEntry copy = ctx.isOriginLocal() ? this.entryFactory.copy(entry) : entry;
                if (trace) {
                    log.tracef("Found entry %s -> %s", key, entry);
                    log.tracef("Returning copied entry %s", copy);
                }
                map.put(key, copy);
                continue;
            }
            Object value = entry.getValue();
            if (trace) {
                log.tracef("Found %s -> %s", key, Util.toStr(value));
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public byte getCommandId() {
        return 44;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
        output.writeBoolean(this.returnEntries);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
        this.flags = (Set)input.readObject();
        this.returnEntries = input.readBoolean();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    public boolean isReturnEntries() {
        return this.returnEntries;
    }

    public <V> Map<Object, V> createMap() {
        return new LinkedHashMap();
    }

    private Set<Object> createSet(Object[] elements) {
        HashSet<Object> set = new HashSet<Object>(elements.length);
        for (Object element : elements) {
            set.add(element);
        }
        return set;
    }

    public Collection<?> getKeys() {
        return this.keys;
    }

    public void setKeys(Collection<?> keys) {
        this.keys = keys;
    }

    public Map<Object, InternalCacheEntry> getRemotelyFetched() {
        return this.remotelyFetched;
    }

    public void setRemotelyFetched(Map<Object, InternalCacheEntry> remotelyFetched) {
        this.remotelyFetched = remotelyFetched;
    }

    public void setConsistentHash(ConsistentHash ch) {
        this.ch = ch;
    }

    public ConsistentHash getConsistentHash() {
        return this.ch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GetAllCommand{");
        sb.append("keys=").append(this.keys);
        sb.append(", returnEntries=").append(this.returnEntries);
        sb.append(", flags=").append(this.flags);
        sb.append('}');
        return sb.toString();
    }
}

