/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler.action;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.remoting.inboundhandler.action.ActionListener;
import org.infinispan.remoting.inboundhandler.action.ReadyAction;

public class CompositeAction
implements ReadyAction,
ActionListener {
    private final Collection<ReadyAction> actions;
    private final AtomicBoolean notify;
    private volatile ActionListener listener;

    public CompositeAction(Collection<ReadyAction> actions) {
        this.actions = actions;
        this.notify = new AtomicBoolean(false);
    }

    public void registerListener() {
        this.actions.forEach(readyAction -> readyAction.addListener(this));
    }

    @Override
    public boolean isReady() {
        for (ReadyAction action : this.actions) {
            if (action.isReady()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addListener(ActionListener listener) {
        this.listener = listener;
    }

    @Override
    public void cleanup() {
        this.actions.forEach(ReadyAction::cleanup);
    }

    @Override
    public void onComplete() {
        ActionListener actionListener = this.listener;
        if (this.isReady() && actionListener != null && this.notify.compareAndSet(false, true)) {
            actionListener.onComplete();
        }
    }
}

