/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.Stats;
import org.infinispan.util.TimeService;

@MBean(objectName="Statistics", description="General statistics such as timings, hit/miss ratio, etc.")
public class StatsCollector
implements Stats,
JmxStatisticsExposer {
    private final LongAdder hitTimes = new LongAdder();
    private final LongAdder missTimes = new LongAdder();
    private final LongAdder storeTimes = new LongAdder();
    private final LongAdder removeTimes = new LongAdder();
    private final LongAdder hits = new LongAdder();
    private final LongAdder misses = new LongAdder();
    private final LongAdder stores = new LongAdder();
    private final LongAdder evictions = new LongAdder();
    private final AtomicLong startNanoseconds = new AtomicLong(0L);
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private final LongAdder removeHits = new LongAdder();
    private final LongAdder removeMisses = new LongAdder();
    private TimeService timeService;
    private DataContainer dataContainer;
    private Configuration configuration;
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", writable=true)
    private boolean statisticsEnabled = false;

    @Inject
    public void injectDependencies(TimeService timeService, DataContainer dataContainer, Configuration configuration) {
        this.timeService = timeService;
        this.dataContainer = dataContainer;
        this.configuration = configuration;
    }

    @Start
    public void start() {
        this.statisticsEnabled = this.configuration.jmxStatistics().enabled();
    }

    @Override
    @ManagedAttribute(description="Number of cache attribute hits", displayName="Number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.hits.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache attribute misses", displayName="Number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.misses.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache removal hits", displayName="Number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.removeHits.sum();
    }

    @Override
    @ManagedAttribute(description="Number of cache removals where keys were not found", displayName="Number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.removeMisses.sum();
    }

    @Override
    @ManagedAttribute(description="number of cache attribute put operations", displayName="Number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.stores.sum();
    }

    @Override
    public long getRetrievals() {
        return this.hits.longValue() + this.misses.longValue();
    }

    @Override
    @ManagedAttribute(description="Number of cache eviction operations", displayName="Number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.evictions.sum();
    }

    @ManagedAttribute(description="Percentage hit/(hit+miss) ratio for the cache", displayName="Hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        long hitsL = this.hits.sum();
        double total = hitsL + this.misses.sum();
        if (total <= 0.0) {
            return 0.0;
        }
        return (double)hitsL / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache", displayName="Read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0.0;
        }
        return (double)(this.hits.sum() + this.misses.sum()) / (double)sum;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a read operation on the cache", displayName="Average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        long total = this.hits.sum() + this.misses.sum();
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes.sum() + this.missTimes.sum()) / total;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a write operation in the cache", displayName="Average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        long sum = this.stores.sum();
        if (sum == 0L) {
            return 0L;
        }
        return this.storeTimes.sum() / sum;
    }

    @Override
    @ManagedAttribute(description="Average number of milliseconds for a remove operation in the cache", displayName="Average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        long removes = this.getRemoveHits();
        if (removes == 0L) {
            return 0L;
        }
        return this.removeTimes.sum() / removes;
    }

    @Override
    public void reset() {
        this.resetStatistics();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of entries currently in the cache", displayName="Number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.dataContainer.size();
    }

    @Override
    @ManagedAttribute(description="Number of seconds since cache started", displayName="Seconds since cache started", units=Units.SECONDS, measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        return this.timeService.timeDuration(this.startNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the cache statistics were last reset", displayName="Seconds since cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        return this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.stores.longValue();
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics (Statistics)")
    public void resetStatistics() {
        this.hits.reset();
        this.misses.reset();
        this.stores.reset();
        this.evictions.reset();
        this.hitTimes.reset();
        this.missTimes.reset();
        this.storeTimes.reset();
        this.removeHits.reset();
        this.removeTimes.reset();
        this.removeMisses.reset();
        this.resetNanoseconds.set(this.timeService.time());
    }

    public void recordMisses(int misses, long time) {
        this.misses.add(misses);
        this.missTimes.add(time);
    }

    public void recordHits(int hits, long time) {
        this.hits.add(hits);
        this.hitTimes.add(time);
    }

    public void recordEviction() {
        this.evictions.increment();
    }

    public void recordStores(int stores, long time) {
        this.stores.add(stores);
        this.storeTimes.add(time);
    }

    public void recordRemoveHits(int removes, long time) {
        this.removeHits.add(removes);
        this.removeTimes.add(time);
    }

    public void recordRemoveMisses(int removes) {
        this.removeMisses.add(removes);
    }

    @DefaultFactoryFor(classes={StatsCollector.class})
    @SurvivesRestarts
    public static class Factory
    extends AbstractNamedCacheComponentFactory {
        @Override
        public <T> T construct(Class<T> componentType) {
            if (componentType.isAssignableFrom(StatsCollector.class)) {
                return componentType.cast(new StatsCollector());
            }
            throw new CacheException("Don't know how to handle type " + componentType);
        }
    }
}

