/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.apache.taglibs.standard.tag.common.core.Util;
import org.apache.taglibs.standard.tag.common.xml.ModularUtil;
import org.apache.taglibs.standard.tag.common.xml.ParseSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class TransformSupport
extends BodyTagSupport {
    protected Object xml;
    protected boolean xmlSpecified;
    protected String xmlSystemId;
    protected Object xslt;
    protected String xsltSystemId;
    protected Result result;
    private String var;
    private int scope;
    private Transformer t;
    private TransformerFactory tf;
    private DocumentBuilder db;

    public TransformSupport() {
        try {
            DocumentBuilderFactory dbf = ModularUtil.createDocumentBuilderFactory();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            this.db = dbf.newDocumentBuilder();
            this.tf = ModularUtil.createTransformerFactory();
        }
        catch (ParserConfigurationException e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)"Unable to create DocumentBuilder"))).initCause(e));
        }
        this.init();
    }

    private void init() {
        this.xslt = null;
        this.xml = null;
        this.xmlSpecified = false;
        this.xsltSystemId = null;
        this.xmlSystemId = null;
        this.var = null;
        this.result = null;
        this.tf.setURIResolver(null);
        this.scope = 1;
    }

    public int doStartTag() throws JspException {
        this.t = this.getTransformer(this.xslt, this.xsltSystemId);
        return 2;
    }

    public int doEndTag() throws JspException {
        Source source = this.xmlSpecified ? this.getSourceFromXmlAttribute() : this.getDocumentFromBodyContent();
        try {
            if (this.result != null) {
                this.t.transform(source, this.result);
            } else if (this.var != null) {
                Document d = this.db.newDocument();
                DOMResult doc = new DOMResult(d);
                this.t.transform(source, doc);
                this.pageContext.setAttribute(this.var, (Object)d, this.scope);
            } else {
                StreamResult page = new StreamResult(new SafeWriter((Writer)this.pageContext.getOut()));
                this.t.transform(source, page);
            }
            return 6;
        }
        catch (TransformerException ex) {
            throw new JspException((Throwable)ex);
        }
    }

    public void release() {
        super.release();
        this.init();
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.tf.setURIResolver(pageContext == null ? null : new JstlUriResolver(pageContext));
    }

    public void addParameter(String name, Object value) {
        this.t.setParameter(name, value);
    }

    private static String wrapSystemId(String systemId) {
        if (systemId == null) {
            return "jstl:";
        }
        if (ImportSupport.isAbsoluteUrl(systemId)) {
            return systemId;
        }
        return "jstl:" + systemId;
    }

    Transformer getTransformer(Object xslt, String systemId) throws JspException {
        Source source;
        if (xslt == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_IS_NULL"));
        }
        if (xslt instanceof Source) {
            source = (Source)xslt;
        } else {
            if (xslt instanceof String) {
                String s = (String)xslt;
                if ((s = s.trim()).length() == 0) {
                    throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_IS_EMPTY"));
                }
                xslt = new StringReader(s);
            }
            if (xslt instanceof Reader) {
                source = this.getSource((Reader)xslt, systemId);
            } else {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XSLT_UNSUPPORTED_TYPE", xslt.getClass()));
            }
        }
        try {
            return this.tf.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    Source getSourceFromXmlAttribute() throws JspTagException {
        Object xml = this.xml;
        if (xml == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_XML_IS_NULL"));
        }
        if (xml instanceof List) {
            List list = (List)xml;
            if (list.size() != 1) {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XML_LIST_SIZE"));
            }
            xml = list.get(0);
        }
        if (xml instanceof Source) {
            return (Source)xml;
        }
        if (xml instanceof String) {
            String s = (String)xml;
            if ((s = s.trim()).length() == 0) {
                throw new JspTagException(Resources.getMessage("TRANSFORM_XML_IS_EMPTY"));
            }
            return this.getSource(new StringReader(s), this.xmlSystemId);
        }
        if (xml instanceof Reader) {
            return this.getSource((Reader)xml, this.xmlSystemId);
        }
        if (xml instanceof Node) {
            return new DOMSource((Node)xml, this.xmlSystemId);
        }
        throw new JspTagException(Resources.getMessage("TRANSFORM_XML_UNSUPPORTED_TYPE", xml.getClass()));
    }

    Source getDocumentFromBodyContent() throws JspTagException {
        if (this.bodyContent == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_IS_NULL"));
        }
        String s = this.bodyContent.getString();
        if (s == null) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_CONTENT_IS_NULL"));
        }
        if ((s = s.trim()).length() == 0) {
            throw new JspTagException(Resources.getMessage("TRANSFORM_BODY_IS_EMPTY"));
        }
        return this.getSource(new StringReader(s), this.xmlSystemId);
    }

    Source getSource(Reader reader, String systemId) throws JspTagException {
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            xr.setEntityResolver(new ParseSupport.JstlEntityResolver(this.pageContext));
            InputSource s = new InputSource(reader);
            s.setSystemId(TransformSupport.wrapSystemId(systemId));
            SAXSource source = new SAXSource(xr, s);
            source.setSystemId(TransformSupport.wrapSystemId(systemId));
            return source;
        }
        catch (SAXException e) {
            throw new JspTagException((Throwable)e);
        }
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
    }

    private static class JstlUriResolver
    implements URIResolver {
        private final PageContext ctx;

        public JstlUriResolver(PageContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            InputStream s;
            int index;
            if (href == null) {
                return null;
            }
            if (base != null && (index = base.indexOf("jstl:")) != -1) {
                base = base.substring(index + 5);
            }
            if (ImportSupport.isAbsoluteUrl(href) || base != null && ImportSupport.isAbsoluteUrl(base)) {
                return null;
            }
            String target = (base = base == null || base.lastIndexOf("/") == -1 ? "" : base.substring(0, base.lastIndexOf("/") + 1)) + href;
            if (target.startsWith("/")) {
                s = this.ctx.getServletContext().getResourceAsStream(target);
                if (s == null) {
                    throw new TransformerException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", href));
                }
            } else {
                String pagePath = ((HttpServletRequest)this.ctx.getRequest()).getServletPath();
                String basePath = pagePath.substring(0, pagePath.lastIndexOf("/"));
                s = this.ctx.getServletContext().getResourceAsStream(basePath + "/" + target);
                if (s == null) {
                    throw new TransformerException(Resources.getMessage("UNABLE_TO_RESOLVE_ENTITY", href));
                }
            }
            return new StreamSource(s);
        }
    }

    private static class SafeWriter
    extends Writer {
        private Writer w;

        public SafeWriter(Writer w) {
            this.w = w;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.w.write(cbuf, off, len);
        }
    }
}

