/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.impl.InfinispanIndexOutput;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class FileListOperations {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private final boolean trace = log.isTraceEnabled();
    private final FileListCacheKey fileListCacheKey;
    private final AdvancedCache<FileListCacheKey, Object> cache;
    private final String indexName;
    private final AdvancedCache<FileListCacheKey, FileListCacheValue> cacheNoRetrieve;
    private final Lock readLock;
    private final Lock writeLock;
    private final boolean writeAsync;
    private final int affinitySegmentId;

    public FileListOperations(AdvancedCache<?, ?> cache, String indexName, boolean writeAsync, int affinitySegmentId) {
        this.writeAsync = writeAsync;
        this.affinitySegmentId = affinitySegmentId;
        this.cache = cache;
        this.cacheNoRetrieve = cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.indexName = indexName;
        this.fileListCacheKey = new FileListCacheKey(indexName, affinitySegmentId);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFileName(String fileName) {
        this.writeLock.lock();
        try {
            FileListCacheValue fileList = this.getFileList();
            boolean done = fileList.add(fileName);
            if (done) {
                this.updateFileList(fileList);
                if (this.trace) {
                    log.trace((Object)("Updated file listing: added " + fileName));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public FileMetadata getFileMetadata(String fileName) {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName, this.affinitySegmentId);
        FileMetadata metadata = (FileMetadata)this.cache.get((Object)key);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndAdd(String toRemove, String toAdd) {
        this.writeLock.lock();
        try {
            FileListCacheValue fileList = this.getFileList();
            boolean done = fileList.addAndRemove(toAdd, toRemove);
            if (done) {
                this.updateFileList(fileList);
                if (this.trace) {
                    log.trace((Object)("Updated file listing: added " + toAdd + " and removed " + toRemove));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] listFilenames() {
        this.readLock.lock();
        try {
            String[] stringArray = this.getFileList().toArray();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean fileExists(String fileName) {
        this.readLock.lock();
        try {
            boolean bl = this.getFileList().contains(fileName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFileName(String fileName) {
        this.writeLock.lock();
        try {
            FileListCacheValue fileList = this.getFileList();
            boolean done = fileList.remove(fileName);
            if (done) {
                this.updateFileList(fileList);
                if (this.trace) {
                    log.trace((Object)("Updated file listing: removed " + fileName));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @GuardedBy(value="writeLock")
    private void updateFileList(FileListCacheValue fileList) {
        if (this.writeAsync) {
            this.cacheNoRetrieve.putAsync((Object)this.fileListCacheKey, (Object)fileList);
        } else {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, (Object)fileList);
        }
    }

    @GuardedBy(value="writeLock")
    private FileListCacheValue getFileList() {
        FileListCacheValue prev;
        FileListCacheValue fileList = (FileListCacheValue)this.cache.get((Object)this.fileListCacheKey);
        if (fileList == null && (prev = (FileListCacheValue)this.cache.putIfAbsent((Object)this.fileListCacheKey, (Object)(fileList = new FileListCacheValue()))) != null) {
            fileList = prev;
        }
        if (this.trace) {
            log.trace((Object)"Refreshed file listing view");
        }
        return fileList;
    }
}

