/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.driver;

import org.jboss.modules.ModuleIdentifier;

public final class InstalledDriver {
    private final String driverName;
    private final ModuleIdentifier moduleName;
    private final String deploymentUnitName;
    private final String driverClassName;
    private final String dataSourceClassName;
    private final String xaDataSourceClassName;
    private final int majorVersion;
    private final int minorVersion;
    private final boolean jdbcCompliant;

    public InstalledDriver(String driverName, ModuleIdentifier moduleName, String driverClassName, String dataSourceClassName, String xaDataSourceClassName, int majorVersion, int minorVersion, boolean jdbcCompliant) {
        this.deploymentUnitName = null;
        this.moduleName = moduleName;
        this.driverName = driverName;
        this.driverClassName = driverClassName;
        this.dataSourceClassName = dataSourceClassName;
        this.xaDataSourceClassName = xaDataSourceClassName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.jdbcCompliant = jdbcCompliant;
    }

    public InstalledDriver(String deploymentUnitName, String driverClassName, String dataSourceClassName, String xaDataSourceClassName, int majorVersion, int minorVersion, boolean jdbcCompliant) {
        this.deploymentUnitName = deploymentUnitName;
        this.moduleName = null;
        this.driverName = deploymentUnitName;
        this.driverClassName = driverClassName;
        this.dataSourceClassName = dataSourceClassName;
        this.xaDataSourceClassName = xaDataSourceClassName;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.jdbcCompliant = jdbcCompliant;
    }

    public ModuleIdentifier getModuleName() {
        return this.moduleName;
    }

    public String getDeploymentUnitName() {
        return this.deploymentUnitName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public boolean isFromDeployment() {
        return this.deploymentUnitName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstalledDriver that = (InstalledDriver)o;
        if (this.jdbcCompliant != that.jdbcCompliant) {
            return false;
        }
        if (this.majorVersion != that.majorVersion) {
            return false;
        }
        if (this.minorVersion != that.minorVersion) {
            return false;
        }
        if (this.dataSourceClassName != null ? !this.dataSourceClassName.equals(that.dataSourceClassName) : that.dataSourceClassName != null) {
            return false;
        }
        if (this.deploymentUnitName != null ? !this.deploymentUnitName.equals(that.deploymentUnitName) : that.deploymentUnitName != null) {
            return false;
        }
        if (this.driverClassName != null ? !this.driverClassName.equals(that.driverClassName) : that.driverClassName != null) {
            return false;
        }
        if (this.driverName != null ? !this.driverName.equals(that.driverName) : that.driverName != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        return !(this.xaDataSourceClassName != null ? !this.xaDataSourceClassName.equals(that.xaDataSourceClassName) : that.xaDataSourceClassName != null);
    }

    public int hashCode() {
        int result = this.driverName != null ? this.driverName.hashCode() : 0;
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.deploymentUnitName != null ? this.deploymentUnitName.hashCode() : 0);
        result = 31 * result + (this.driverClassName != null ? this.driverClassName.hashCode() : 0);
        result = 31 * result + (this.dataSourceClassName != null ? this.dataSourceClassName.hashCode() : 0);
        result = 31 * result + (this.xaDataSourceClassName != null ? this.xaDataSourceClassName.hashCode() : 0);
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        result = 31 * result + (this.jdbcCompliant ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.moduleName != null) {
            sb.append(this.moduleName);
        } else {
            sb.append(this.deploymentUnitName);
        }
        sb.append(':');
        sb.append(this.driverClassName);
        sb.append('#');
        sb.append(this.majorVersion);
        sb.append('#');
        sb.append(this.minorVersion);
        return sb.toString();
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }
}

