/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.as.server.deployment.AttachmentKey;

public class DelegatingClassFileTransformer
implements ClassFileTransformer {
    private final List<ClassFileTransformer> delegateTransformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    public static final AttachmentKey<DelegatingClassFileTransformer> ATTACHMENT_KEY = AttachmentKey.create(DelegatingClassFileTransformer.class);
    private volatile boolean active = false;

    public void addTransformer(ClassFileTransformer classFileTransformer) {
        this.delegateTransformers.add(classFileTransformer);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] originalBuffer) throws IllegalClassFormatException {
        byte[] transformedBuffer = originalBuffer;
        if (this.active) {
            for (ClassFileTransformer transformer : this.delegateTransformers) {
                byte[] result = transformer.transform(loader, className, classBeingRedefined, protectionDomain, transformedBuffer);
                if (result == null) continue;
                transformedBuffer = result;
            }
        }
        return transformedBuffer;
    }
}

