/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.entity;

import java.lang.reflect.Method;
import javax.ejb.TransactionManagementType;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewConfigurator;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.concurrent.handle.ContextHandleFactory;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.concurrent.EJBContextHandleFactory;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentCreateService;
import org.jboss.as.ejb3.component.entity.EntityBeanHomeViewConfigurator;
import org.jboss.as.ejb3.component.entity.EntityBeanInterceptors;
import org.jboss.as.ejb3.component.entity.EntityBeanObjectViewConfigurator;
import org.jboss.as.ejb3.component.entity.EntityBeanRemoteViewInstanceFactory;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanAssociatingInterceptor;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanReentrancyInterceptor;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanRemoveInterceptor;
import org.jboss.as.ejb3.component.entity.interceptors.EntityBeanSynchronizationInterceptor;
import org.jboss.as.ejb3.component.interceptors.CurrentInvocationContextInterceptor;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.StrictMaxPoolConfigService;
import org.jboss.as.ejb3.deployment.EjbJarDescription;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemDefaultEntityBeanOptimisticLockingWriteHandler;
import org.jboss.as.ejb3.tx.CMTTxInterceptor;
import org.jboss.as.ejb3.tx.TimerCMTTxInterceptor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.EnterpriseBeanMetaData;
import org.jboss.metadata.ejb.spec.EntityBeanMetaData;
import org.jboss.metadata.ejb.spec.PersistenceType;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public class EntityBeanComponentDescription
extends EJBComponentDescription {
    private PersistenceType persistenceType;
    private boolean reentrant;
    private String primaryKeyType;
    private String poolConfigName;

    public EntityBeanComponentDescription(String componentName, String componentClassName, EjbJarDescription ejbJarDescription, ServiceName deploymentUnitServiceName, EntityBeanMetaData descriptorData) {
        super(componentName, componentClassName, ejbJarDescription, deploymentUnitServiceName, (EnterpriseBeanMetaData)descriptorData);
        this.addSynchronizationInterceptor();
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addPostConstructInterceptor(EntityBeanInterceptors.POST_CONSTRUCT, 4864);
                configuration.addTimeoutViewInterceptor(EntityBeanAssociatingInterceptor.FACTORY, 1792);
            }
        });
        this.addRemoveInterceptor();
    }

    protected void addRemoveInterceptor() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                for (Method method : configuration.getDefinedComponentMethods()) {
                    if (!method.getName().equals("ejbRemove") || method.getParameterTypes().length != 0) continue;
                    configuration.addComponentInterceptor(method, EntityBeanRemoveInterceptor.FACTORY, 1360);
                }
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory() {
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addPostConstructInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                configuration.addPreDestroyInterceptor(CurrentInvocationContextInterceptor.FACTORY, 512);
                configuration.getConcurrentContext().addFactory((ContextHandleFactory)EJBContextHandleFactory.INSTANCE);
            }
        });
    }

    @Override
    protected void addCurrentInvocationContextFactory(ViewDescription view) {
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addViewInterceptor(CurrentInvocationContextInterceptor.FACTORY, 1024);
            }
        });
    }

    public final ComponentConfiguration createConfiguration(ClassReflectionIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        ComponentConfiguration configuration = this.createEntityBeanConfiguration(classIndex, moduleClassLoader, moduleLoader);
        configuration.getCreateDependencies().add(new ConfigInjectingConfigurator(this));
        this.getConfigurators().add(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addTimeoutViewInterceptor(TimerCMTTxInterceptor.FACTORY, 1280);
            }
        });
        return configuration;
    }

    protected ComponentConfiguration createEntityBeanConfiguration(ClassReflectionIndex classIndex, ClassLoader moduleClassLoader, ModuleLoader moduleLoader) {
        ComponentConfiguration configuration = new ComponentConfiguration((ComponentDescription)this, classIndex, moduleClassLoader, moduleLoader);
        configuration.setComponentCreateServiceFactory(EntityBeanComponentCreateService.FACTORY);
        return configuration;
    }

    @Override
    protected void setupViewInterceptors(EJBViewDescription view) {
        super.setupViewInterceptors(view);
        view.getConfigurators().add(new ViewConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
                if (TransactionManagementType.CONTAINER.equals((Object)ejbComponentDescription.getTransactionManagementType())) {
                    configuration.addViewInterceptor(CMTTxInterceptor.FACTORY, 1280);
                }
            }
        });
        if (view instanceof EjbHomeViewDescription) {
            view.getConfigurators().add(this.getHomeViewConfigurator());
        } else {
            view.getConfigurators().add(this.getObjectViewConfigurator());
        }
        if (view.getMethodIntf() == MethodIntf.REMOTE) {
            view.getConfigurators().add(new ViewConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentConfiguration componentConfiguration, ViewDescription description, ViewConfiguration configuration) throws DeploymentUnitProcessingException {
                    EEModuleDescription moduleDescription = componentConfiguration.getComponentDescription().getModuleDescription();
                    String appName = moduleDescription.getEarApplicationName() == null ? "" : moduleDescription.getEarApplicationName();
                    configuration.setViewInstanceFactory(EntityBeanComponentDescription.this.getRemoteViewInstanceFactory(appName, componentConfiguration.getModuleName(), moduleDescription.getDistinctName(), componentConfiguration.getComponentName()));
                }
            });
        }
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    protected EntityBeanObjectViewConfigurator getObjectViewConfigurator() {
        return new EntityBeanObjectViewConfigurator();
    }

    protected EntityBeanHomeViewConfigurator getHomeViewConfigurator() {
        return new EntityBeanHomeViewConfigurator();
    }

    protected ViewInstanceFactory getRemoteViewInstanceFactory(String applicationName, String moduleName, String distinctName, String componentName) {
        return new EntityBeanRemoteViewInstanceFactory(applicationName, moduleName, distinctName, componentName);
    }

    protected void addSynchronizationInterceptor() {
        this.getConfigurators().addFirst(new ComponentConfigurator(){

            public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.addComponentInterceptor(EntityBeanComponentDescription.this.getSynchronizationInterceptorFactory(), 1280, false);
                if (!EntityBeanComponentDescription.this.reentrant) {
                    configuration.addComponentInterceptor(EntityBeanReentrancyInterceptor.FACTORY, 1281, false);
                }
            }
        });
    }

    protected InterceptorFactory getSynchronizationInterceptorFactory() {
        return EntityBeanSynchronizationInterceptor.FACTORY;
    }

    public String getPrimaryKeyType() {
        return this.primaryKeyType;
    }

    public void setPrimaryKeyType(String primaryKeyType) {
        this.primaryKeyType = primaryKeyType;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    public void setReentrant(boolean reentrant) {
        this.reentrant = reentrant;
    }

    public PersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    public void setPersistenceType(PersistenceType persistenceType) {
        this.persistenceType = persistenceType;
    }

    public boolean isTimerServiceApplicable() {
        return true;
    }

    public String getPoolConfigName() {
        return this.poolConfigName;
    }

    public void setPoolConfigName(String poolConfigName) {
        this.poolConfigName = poolConfigName;
    }

    private class ConfigInjectingConfigurator
    implements DependencyConfigurator<Service<Component>> {
        private final EntityBeanComponentDescription entityComponentDescription;

        ConfigInjectingConfigurator(EntityBeanComponentDescription entityComponentDescription) {
            this.entityComponentDescription = entityComponentDescription;
        }

        public void configureDependency(ServiceBuilder<?> serviceBuilder, Service<Component> service) throws DeploymentUnitProcessingException {
            EntityBeanComponentCreateService entityBeanComponentCreateService = (EntityBeanComponentCreateService)service;
            String poolName = this.entityComponentDescription.getPoolConfigName();
            if (poolName == null) {
                serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, StrictMaxPoolConfigService.DEFAULT_ENTITY_POOL_CONFIG_SERVICE_NAME, PoolConfig.class, entityBeanComponentCreateService.getPoolConfigInjector());
            } else {
                serviceBuilder.addDependency(StrictMaxPoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName}), PoolConfig.class, entityBeanComponentCreateService.getPoolConfigInjector());
            }
            serviceBuilder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, EJB3SubsystemDefaultEntityBeanOptimisticLockingWriteHandler.SERVICE_NAME, Boolean.class, entityBeanComponentCreateService.getOptimisticLockingInjector());
        }
    }
}

