/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import java.rmi.RemoteException;
import javax.ejb.ConcurrentAccessException;
import javax.ejb.ConcurrentAccessTimeoutException;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.component.interceptors.AbstractEJBInterceptor;
import org.jboss.invocation.InterceptorContext;

public class NonPooledEJBComponentInstanceAssociatingInterceptor
extends AbstractEJBInterceptor {
    public static final NonPooledEJBComponentInstanceAssociatingInterceptor INSTANCE = new NonPooledEJBComponentInstanceAssociatingInterceptor();

    private NonPooledEJBComponentInstanceAssociatingInterceptor() {
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        EJBComponent component = NonPooledEJBComponentInstanceAssociatingInterceptor.getComponent(context, EJBComponent.class);
        ComponentInstance componentInstance = component.createInstance();
        context.putPrivateData(ComponentInstance.class, (Object)componentInstance);
        boolean discard = false;
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception ex) {
            EJBComponent ejbComponent = component;
            if (ejbComponent.getApplicationException(ex.getClass(), context.getMethod()) != null) {
                throw ex;
            }
            if (ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
                throw ex;
            }
            if (ex instanceof RuntimeException || ex instanceof RemoteException) {
                discard = true;
            }
            throw ex;
        }
        catch (Error e) {
            discard = true;
            throw e;
        }
        catch (Throwable t) {
            discard = true;
            throw new RuntimeException(t);
        }
        finally {
            if (!discard) {
                componentInstance.destroy();
            }
        }
    }
}

