/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.command.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandNotFoundException;
import org.jboss.aesh.console.command.container.AeshCommandContainerBuilder;
import org.jboss.aesh.console.command.container.CommandContainer;
import org.jboss.aesh.console.command.container.CommandContainerBuilder;
import org.jboss.aesh.console.command.registry.CommandRegistry;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.util.LoggerUtil;

public class MutableCommandRegistry
implements CommandRegistry {
    private final Map<String, CommandContainer<Command>> registry = new HashMap<String, CommandContainer<Command>>();
    private CommandContainerBuilder containerBuilder;
    private static final Logger LOGGER = LoggerUtil.getLogger(MutableCommandRegistry.class.getName());

    public void setCommandContainerBuilder(CommandContainerBuilder containerBuilder) {
        this.containerBuilder = containerBuilder;
    }

    @Override
    public CommandContainer getCommand(String name, String line) throws CommandNotFoundException {
        if (this.registry.containsKey(name)) {
            return this.registry.get(name);
        }
        if (name.contains(" ")) {
            String[] names = name.split(" ");
            if (this.registry.containsKey(names[0])) {
                return this.registry.get(names[0]);
            }
            throw new CommandNotFoundException("Command: " + names[0] + " was not found.");
        }
        throw new CommandNotFoundException("Command: " + name + " was not found.");
    }

    @Override
    public void completeCommandName(CompleteOperation co) {
        ArrayList<String> names = new ArrayList<String>();
        for (CommandContainer<Command> command : this.registry.values()) {
            if (command.getParser().getProcessedCommand().getName().startsWith(co.getBuffer())) {
                if (command.getParser().isGroupCommand()) {
                    LOGGER.info("command is a group command");
                    if (!command.getParser().getProcessedCommand().hasOptions() && !command.getParser().getProcessedCommand().hasArgument()) {
                        LOGGER.info("adding add: " + command.getParser().getAllNames());
                        names.addAll(command.getParser().getAllNames());
                        co.setIgnoreNonEscapedSpace(true);
                        continue;
                    }
                    names.add(command.getParser().getProcessedCommand().getName());
                    continue;
                }
                names.add(command.getParser().getProcessedCommand().getName());
                continue;
            }
            if (!command.getParser().isGroupCommand() || !co.getBuffer().startsWith(command.getParser().getProcessedCommand().getName())) continue;
            String groupLine = Parser.trimInFront(co.getBuffer().substring(command.getParser().getProcessedCommand().getName().length()));
            int diff = co.getBuffer().length() - groupLine.length();
            for (CommandLineParser<Command> child : command.getParser().getAllChildParsers()) {
                if (!child.getProcessedCommand().getName().startsWith(groupLine)) continue;
                names.add(co.getBuffer().substring(0, diff) + child.getProcessedCommand().getName());
            }
        }
        co.addCompletionCandidates(names);
    }

    @Override
    public Set<String> getAllCommandNames() {
        return this.registry.keySet();
    }

    public void addCommand(CommandContainer container) {
        this.putIntoRegistry(container);
    }

    public void addCommand(Command command) {
        this.putIntoRegistry(this.getBuilder().create(command));
    }

    public void addCommand(Class<? extends Command> command) {
        this.putIntoRegistry(this.getBuilder().create(command));
    }

    public void addAllCommands(List<Command> commands) {
        if (commands != null) {
            for (Command command : commands) {
                this.addCommand(command);
            }
        }
    }

    public void addAllCommandContainers(List<CommandContainer> commands) {
        if (commands != null) {
            for (CommandContainer command : commands) {
                this.addCommand(command);
            }
        }
    }

    private void putIntoRegistry(CommandContainer commandContainer) {
        if (!commandContainer.haveBuildError() && !this.registry.containsKey(commandContainer.getParser().getProcessedCommand().getName())) {
            this.registry.put(commandContainer.getParser().getProcessedCommand().getName(), commandContainer);
        }
    }

    @Override
    public void removeCommand(String name) {
        if (this.registry.containsKey(name)) {
            this.registry.remove(name);
        }
    }

    private CommandContainerBuilder getBuilder() {
        if (this.containerBuilder == null) {
            this.containerBuilder = new AeshCommandContainerBuilder();
        }
        return this.containerBuilder;
    }
}

