/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.value;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.msc.value.CachedValue;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.ThreadLocalValue;
import org.jboss.msc.value.Value;

public final class Values {
    private static final ThreadLocalValue<Object> THIS = new ThreadLocalValue();
    private static final ThreadLocalValue<Object> INJECTED = new ThreadLocalValue();
    private static final Value NULL = new ImmediateValue<Object>(null);
    private static final Object[] NONE = new Object[0];
    public static final List<Value<?>> EMPTY_LIST = Values.emptyList();
    public static final List<? extends Value<Class<?>>> EMPTY_TYPE_LIST = new ArrayList();
    private static final Value EMPTY_LIST_VALUE = new ImmediateValue(Collections.emptyList());

    private Values() {
    }

    private static <T> T[] getValues(Iterator<? extends Value<? extends T>> i, Class<T> clazz, int idx) {
        if (i.hasNext()) {
            Value<T> v = i.next();
            T[] params = Values.getValues(i, clazz, idx + 1);
            params[idx] = v.getValue();
            return params;
        }
        return Values.arrayOf(clazz, idx);
    }

    private static <T> T[] arrayOf(Class<T> clazz, int len) {
        return (Object[])Array.newInstance(clazz, len);
    }

    private static Object[] getValues(Iterator<? extends Value<?>> i, int idx) {
        if (i.hasNext()) {
            Value<?> v = i.next();
            Object[] params = Values.getValues(i, idx + 1);
            params[idx] = v.getValue();
            return params;
        }
        return idx == 0 ? NONE : new Object[idx];
    }

    public static Object[] getValues(Iterable<? extends Value<?>> i) {
        return Values.getValues(i.iterator(), 0);
    }

    public static <T> T[] getValues(Iterable<? extends Value<? extends T>> i, Class<T> clazz) {
        return Values.getValues(i.iterator(), clazz, 0);
    }

    public static <T> T[] getValues(Iterable<? extends Value<? extends T>> i, T[] array) {
        int idx = 0;
        for (Value<T> value : i) {
            array[idx++] = value.getValue();
        }
        return array;
    }

    public static <T> Value<T> nullValue() {
        return NULL;
    }

    public static <T> Value<T> cached(Value<T> value) {
        if (value instanceof CachedValue || value instanceof ImmediateValue) {
            return value;
        }
        return new CachedValue<T>(value);
    }

    public static <T> List<Value<? extends T>> emptyList() {
        return Collections.emptyList();
    }

    public static <T> Value<T> immediateValue(T value) {
        return new ImmediateValue<T>(value);
    }

    public static <T> Value<List<T>> emptyListValue() {
        return EMPTY_LIST_VALUE;
    }

    public static <T> List<Value<? extends T>> immediateValues(List<T> values) {
        ArrayList<Value<T>> newList = new ArrayList<Value<T>>(values.size());
        for (T value : values) {
            newList.add(new ImmediateValue<T>(value));
        }
        return newList;
    }

    public static <T> List<Value<? extends T>> immediateValues(T ... values) {
        ArrayList<Value<T>> newList = new ArrayList<Value<T>>(values.length);
        for (T value : values) {
            newList.add(new ImmediateValue<T>(value));
        }
        return newList;
    }

    public static <T> Value<T> asSuperclass(Value<? extends T> value) {
        return value;
    }

    public static ThreadLocalValue<Object> thisValue() {
        return THIS;
    }

    public static ThreadLocalValue<Object> injectedValue() {
        return INJECTED;
    }
}

