/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class RoundRobinBalancingStrategy
implements FailoverRequestBalancingStrategy {
    private static final Log log = LogFactory.getLog(RoundRobinBalancingStrategy.class);
    private static final boolean trace = log.isTraceEnabled();
    private int index = 0;
    private SocketAddress[] servers;

    @Override
    public void setServers(Collection<SocketAddress> servers) {
        this.servers = servers.toArray(new InetSocketAddress[servers.size()]);
        if (this.index >= this.servers.length) {
            this.index = 0;
        }
        if (trace) {
            log.tracef("New server list is: " + Arrays.toString(this.servers), new Object[0]);
        }
    }

    @Override
    public SocketAddress nextServer(Set<SocketAddress> failedServers) {
        int i = 0;
        while (true) {
            SocketAddress server = this.getServerByIndex(this.index++);
            if (this.index >= this.servers.length) {
                this.index = 0;
            }
            if (failedServers == null || !failedServers.contains(server) || i >= failedServers.size()) {
                if (trace) {
                    if (failedServers == null) {
                        log.tracef("Selected %s from %s", server, Arrays.toString(this.servers));
                    } else {
                        log.tracef("Selected %s from %s, with failed servers %s", server, Arrays.toString(this.servers), failedServers.toString());
                    }
                }
                return server;
            }
            ++i;
        }
    }

    @Override
    public SocketAddress nextServer() {
        return this.nextServer(null);
    }

    public SocketAddress dryRunNextServer() {
        return this.getServerByIndex(this.index);
    }

    private SocketAddress getServerByIndex(int pos) {
        SocketAddress server = this.servers[pos];
        if (trace) {
            log.tracef("Returning server: %s", server);
        }
        return server;
    }

    public SocketAddress[] getServers() {
        return this.servers;
    }

    public int getNextPosition() {
        return this.index;
    }
}

