/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.hibernate.hql.ast.common.JoinType;
import org.hibernate.hql.ast.origin.hql.resolve.path.AggregationPropertyPath;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.SingleEntityHavingQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public abstract class SingleEntityQueryRendererDelegate<Q, R>
implements QueryRendererDelegate<R> {
    protected static final String SORT_ASC_SPEC = "asc";
    private static final Log log = LoggerFactory.make();
    protected Status status;
    protected String targetTypeName;
    protected Class<?> targetType;
    protected PropertyPath propertyPath;
    protected AggregationPropertyPath.Type aggregationType;
    protected final SingleEntityQueryBuilder<Q> builder;
    protected final List<String> projections = new ArrayList<String>();
    protected final Map<String, String> aliasToEntityType = new HashMap<String, String>();
    protected final Map<String, PropertyPath> aliasToPropertyPath = new HashMap<String, PropertyPath>();
    protected String alias;
    private final Map<String, Object> namedParameters;
    private final EntityNamesResolver entityNames;
    private final PropertyHelper propertyHelper;

    public SingleEntityQueryRendererDelegate(PropertyHelper propertyHelper, EntityNamesResolver entityNames, SingleEntityQueryBuilder<Q> builder, Map<String, Object> namedParameters) {
        this.propertyHelper = propertyHelper;
        this.entityNames = entityNames;
        this.namedParameters = namedParameters != null ? namedParameters : Collections.emptyMap();
        this.builder = builder;
    }

    protected SingleEntityHavingQueryBuilder<?> getHavingBuilder() {
        return null;
    }

    @Override
    public void registerPersisterSpace(Tree entityName, Tree alias) {
        this.registerAlias(entityName.getText(), alias.getText());
        this.setTargetTypeName(entityName.getText());
        this.setTargetType(entityName.getText());
        this.builder.setEntityType(this.targetTypeName);
        if (this.getHavingBuilder() != null) {
            this.getHavingBuilder().setEntityType(this.targetTypeName);
        }
    }

    private void registerAlias(String entityName, String alias) {
        String put = this.aliasToEntityType.put(alias, entityName);
        if (put != null && !put.equalsIgnoreCase(entityName)) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    public void registerEmbeddedAlias(String alias, PropertyPath propertyPath) {
        PropertyPath put = this.aliasToPropertyPath.put(alias, propertyPath);
        if (put != null) {
            throw new UnsupportedOperationException("Alias reuse currently not supported: alias " + alias + " already assigned to type " + put);
        }
    }

    private void setTargetType(String entityName) {
        Class<?> targetedType = this.entityNames.getClassFromName(entityName);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityName);
        }
        this.targetType = targetedType;
    }

    private void setTargetTypeName(String entityName) {
        if (this.targetTypeName != null) {
            throw new IllegalStateException("Can't target multiple types: " + this.targetTypeName + " already selected before " + entityName);
        }
        this.targetTypeName = entityName;
    }

    @Override
    public boolean isUnqualifiedPropertyReference() {
        return true;
    }

    @Override
    public boolean isPersisterReferenceAlias() {
        return this.aliasToEntityType.containsKey(this.alias);
    }

    @Override
    public void pushFromStrategy(JoinType joinType, Tree assosiationFetchTree, Tree propertyFetchTree, Tree alias) {
        this.status = Status.DEFINING_FROM;
        this.alias = alias.getText();
    }

    @Override
    public void pushSelectStrategy() {
        this.status = Status.DEFINING_SELECT;
    }

    @Override
    public void pushWhereStrategy() {
        this.status = Status.DEFINING_WHERE;
    }

    @Override
    public void pushGroupByStrategy() {
        this.status = Status.DEFINING_GROUP_BY;
        if (this.getHavingBuilder() == null) {
            throw new UnsupportedOperationException("The GROUP BY clause is not supported");
        }
    }

    @Override
    public void pushHavingStrategy() {
        this.status = Status.DEFINING_HAVING;
        if (this.getHavingBuilder() == null) {
            throw new UnsupportedOperationException("The HAVING clause is not supported");
        }
    }

    @Override
    public void pushOrderByStrategy() {
        this.status = Status.DEFINING_ORDER_BY;
    }

    @Override
    public void popStrategy() {
        this.status = null;
        this.alias = null;
        this.propertyPath = null;
        this.aggregationType = null;
    }

    @Override
    public void activateOR() {
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.pushOrPredicate();
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().pushOrPredicate();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void activateAND() {
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.pushAndPredicate();
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().pushAndPredicate();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void activateNOT() {
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.pushNotPredicate();
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().pushNotPredicate();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    @Override
    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    @Override
    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    @Override
    public void predicateNotEquals(String comparativePredicate) {
        this.activateNOT();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.deactivateBoolean();
    }

    @Override
    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    @Override
    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.parameterValue(comparativePredicate);
        List<String> property = this.resolveAlias(this.propertyPath);
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().addComparisonPredicate(this.getAggregation(), property, comparisonType, comparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List<String> property = this.resolveAlias(this.propertyPath);
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.addInPredicate(property, values);
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().addInPredicate(this.getAggregation(), property, values);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.parameterValue(lower);
        Object upperComparisonValue = this.parameterValue(upper);
        List<String> property = this.resolveAlias(this.propertyPath);
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().addRangePredicate(this.getAggregation(), property, lowerComparisonValue, upperComparisonValue);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.parameterValue(patternValue);
        List<String> property = this.resolveAlias(this.propertyPath);
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().addLikePredicate(this.getAggregation(), property, (String)pattern, escapeCharacter);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void predicateIsNull() {
        List<String> property = this.resolveAlias(this.propertyPath);
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.addIsNullPredicate(property);
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().addIsNullPredicate(this.getAggregation(), property);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setPropertyReferencePath(PropertyPath propertyPath) {
        if (this.aggregationType != null) {
            if (propertyPath == null && this.aggregationType != AggregationPropertyPath.Type.COUNT && this.aggregationType != AggregationPropertyPath.Type.COUNT_DISTINCT) {
                throw log.getAggregationCanOnlyBeAppliedToPropertyReferencesException(this.aggregationType.name());
            }
            propertyPath = new AggregationPropertyPath(this.aggregationType, propertyPath);
        }
        this.setPropertyPath(propertyPath);
    }

    @Override
    public void activateAggregation(AggregationPropertyPath.Type aggregationType) {
        if (this.status == Status.DEFINING_WHERE) {
            throw log.getNoAggregationsInWhereClauseException(aggregationType.name());
        }
        if (this.status == Status.DEFINING_GROUP_BY) {
            throw log.getNoAggregationsInGroupByClauseException(aggregationType.name());
        }
        this.aggregationType = aggregationType;
        this.propertyPath = null;
    }

    @Override
    public void deactivateAggregation() {
        this.aggregationType = null;
    }

    private AggregationPropertyPath.Type getAggregation() {
        if (this.propertyPath instanceof AggregationPropertyPath) {
            return ((AggregationPropertyPath)this.propertyPath).getType();
        }
        return null;
    }

    @Override
    public void sortSpecification(String collateName, String orderSpec) {
        this.addSortField(this.propertyPath, collateName, SORT_ASC_SPEC.equals(orderSpec));
    }

    @Override
    public void groupingValue(String collateName) {
        this.addGrouping(this.propertyPath, collateName);
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        throw new UnsupportedOperationException("Sorting is not supported : " + propertyPath.asStringPathWithoutAlias());
    }

    protected void addGrouping(PropertyPath propertyPath, String collateName) {
        throw new UnsupportedOperationException("Grouping is not supported : " + propertyPath.asStringPathWithoutAlias());
    }

    private Object parameterValue(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return this.namedParameters.get(comparativePredicate.substring(1));
        }
        ArrayList<String> path = new ArrayList<String>();
        path.addAll(this.propertyPath.getNodeNamesWithoutAlias());
        PropertyPath fullPath = this.propertyPath;
        while (fullPath.getFirstNode().isAlias() && this.aliasToPropertyPath.containsKey(fullPath.getFirstNode().getName())) {
            fullPath = this.aliasToPropertyPath.get(fullPath.getFirstNode().getName());
            path.addAll(0, fullPath.getNodeNamesWithoutAlias());
        }
        return this.propertyHelper.convertToPropertyType(this.targetTypeName, path, comparativePredicate);
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.parameterValue(string));
        }
        return elements;
    }

    @Override
    public void deactivateBoolean() {
        if (this.status == Status.DEFINING_WHERE) {
            this.builder.popBooleanPredicate();
        } else if (this.status == Status.DEFINING_HAVING) {
            this.getHavingBuilder().popBooleanPredicate();
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public abstract R getResult();

    protected List<String> resolveAlias(PropertyPath path) {
        if (path.getFirstNode().isAlias()) {
            String alias = path.getFirstNode().getName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return path.getNodeNamesWithoutAlias();
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath propertyPath = this.aliasToPropertyPath.get(alias);
                List<String> resolvedAlias = this.resolveAlias(propertyPath);
                resolvedAlias.addAll(path.getNodeNamesWithoutAlias());
                return resolvedAlias;
            }
            this.aliasNotFound(alias);
        }
        return path.getNodeNamesWithoutAlias();
    }

    @Override
    public void registerJoinAlias(Tree alias, PropertyPath path) {
        if (!this.aliasToPropertyPath.containsKey(alias.getText())) {
            this.aliasToPropertyPath.put(alias.getText(), path);
        }
    }

    public void aliasNotFound(String alias) {
        throw log.getUnknownAliasException(alias);
    }

    protected static enum Status {
        DEFINING_SELECT,
        DEFINING_FROM,
        DEFINING_WHERE,
        DEFINING_GROUP_BY,
        DEFINING_HAVING,
        DEFINING_ORDER_BY;

    }
}

