/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.james.mime4j.util.ByteArrayBuffer;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.CharsetUtil;

public class ContentUtil {
    private ContentUtil() {
    }

    public static ByteSequence encode(String string) {
        return ContentUtil.encode(CharsetUtil.US_ASCII, string);
    }

    public static ByteSequence encode(Charset charset, String string) {
        ByteBuffer encoded = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer bab = new ByteArrayBuffer(encoded.remaining());
        bab.append(encoded.array(), encoded.position(), encoded.remaining());
        return bab;
    }

    public static String decode(ByteSequence byteSequence) {
        return ContentUtil.decode(CharsetUtil.US_ASCII, byteSequence, 0, byteSequence.length());
    }

    public static String decode(Charset charset, ByteSequence byteSequence) {
        return ContentUtil.decode(charset, byteSequence, 0, byteSequence.length());
    }

    public static String decode(ByteSequence byteSequence, int offset, int length) {
        return ContentUtil.decode(CharsetUtil.US_ASCII, byteSequence, offset, length);
    }

    public static String decode(Charset charset, ByteSequence byteSequence, int offset, int length) {
        if (byteSequence instanceof ByteArrayBuffer) {
            ByteArrayBuffer bab = (ByteArrayBuffer)byteSequence;
            return ContentUtil.decode(charset, bab.buffer(), offset, length);
        }
        byte[] bytes = byteSequence.toByteArray();
        return ContentUtil.decode(charset, bytes, offset, length);
    }

    private static String decode(Charset charset, byte[] buffer, int offset, int length) {
        return charset.decode(ByteBuffer.wrap(buffer, offset, length)).toString();
    }
}

