/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.jboss;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.clustering.marshalling.Externalizer;

public class SimpleClassTable
implements ClassTable {
    private final Class<?>[] classes;
    private final Map<Class<?>, ClassTable.Writer> writers = new IdentityHashMap();
    final Externalizer<Integer> indexExternalizer;

    public SimpleClassTable(Externalizer<Integer> indexExternalizer, Class<?> ... classes) {
        this.indexExternalizer = indexExternalizer;
        this.classes = classes;
        for (int i = 0; i < classes.length; ++i) {
            final int index = i;
            ClassTable.Writer writer = new ClassTable.Writer(){

                public void writeClass(Marshaller output, Class<?> clazz) throws IOException {
                    SimpleClassTable.this.indexExternalizer.writeObject((ObjectOutput)output, (Object)index);
                }
            };
            this.writers.put(classes[i], writer);
        }
    }

    public ClassTable.Writer getClassWriter(Class<?> clazz) {
        return this.writers.get(clazz);
    }

    public Class<?> readClass(Unmarshaller input) throws IOException, ClassNotFoundException {
        return this.classes[(Integer)this.indexExternalizer.readObject((ObjectInput)input)];
    }
}

