/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metadata.Metadata;

public final class ReadWriteManyEntriesCommand<K, V, R>
implements WriteCommand {
    public static final byte COMMAND_ID = 53;
    private Map<? extends K, ? extends V> entries;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private int topologyId = -1;
    boolean isForwarded = false;
    private List<R> remoteReturns = new ArrayList<R>();

    public ReadWriteManyEntriesCommand(Map<? extends K, ? extends V> entries, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f) {
        this.entries = entries;
        this.f = f;
    }

    public ReadWriteManyEntriesCommand() {
    }

    public ReadWriteManyEntriesCommand(ReadWriteManyEntriesCommand command) {
        this.entries = command.entries;
        this.f = command.f;
    }

    public Map<? extends K, ? extends V> getEntries() {
        return this.entries;
    }

    public void setEntries(Map<? extends K, ? extends V> entries) {
        this.entries = entries;
    }

    @Override
    public byte getCommandId() {
        return 53;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.entries);
        output.writeObject(this.f);
        output.writeBoolean(this.isForwarded);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.entries = (Map)input.readObject();
        this.f = (BiFunction)input.readObject();
        this.isForwarded = input.readBoolean();
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public void setForwarded(boolean forwarded) {
        this.isForwarded = forwarded;
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public void addAllRemoteReturns(List<R> returns) {
        this.remoteReturns.addAll(returns);
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteManyEntriesCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        ArrayList<R> returns = new ArrayList<R>(this.remoteReturns);
        this.entries.forEach((k, v) -> {
            CacheEntry entry = ctx.lookupEntry(k);
            if (entry != null) {
                R r = this.f.apply(v, EntryViews.readWrite(entry));
                returns.add(EntryViews.snapshot(r));
            }
        });
        return returns;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Set<Object> getAffectedKeys() {
        return null;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean readsExistingValues() {
        return true;
    }

    @Override
    public boolean alwaysReadsExistingValues() {
        return false;
    }

    @Override
    public Set<Flag> getFlags() {
        return null;
    }

    @Override
    public void setFlags(Set<Flag> flags) {
    }

    @Override
    public void setFlags(Flag ... flags) {
    }

    @Override
    public boolean hasFlag(Flag flag) {
        return false;
    }

    @Override
    public Metadata getMetadata() {
        return null;
    }

    @Override
    public void setMetadata(Metadata metadata) {
    }
}

