/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import java.util.List;
import java.util.Map;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.Slice;

public final class LevelIterator
extends AbstractSeekingIterator<InternalKey, Slice>
implements InternalIterator {
    private final TableCache tableCache;
    private final List<FileMetaData> files;
    private final InternalKeyComparator comparator;
    private InternalTableIterator current;
    private int index;

    public LevelIterator(TableCache tableCache, List<FileMetaData> files, InternalKeyComparator comparator) {
        this.tableCache = tableCache;
        this.files = files;
        this.comparator = comparator;
    }

    @Override
    protected void seekToFirstInternal() {
        this.index = 0;
        this.current = null;
    }

    @Override
    protected void seekInternal(InternalKey targetKey) {
        if (this.files.size() == 0) {
            return;
        }
        int left = 0;
        int right = this.files.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.comparator.compare(this.files.get(mid).getLargest(), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        this.index = right;
        if (this.index == this.files.size() - 1 && this.comparator.compare(this.files.get(this.index).getLargest(), targetKey) < 0) {
            ++this.index;
        }
        if (this.index < this.files.size()) {
            this.current = this.openNextFile();
            this.current.seek(targetKey);
        } else {
            this.current = null;
        }
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        boolean currentHasNext = false;
        while (true) {
            if (this.current != null) {
                currentHasNext = this.current.hasNext();
            }
            if (currentHasNext || this.index >= this.files.size()) break;
            this.current = this.openNextFile();
        }
        if (currentHasNext) {
            return this.current.next();
        }
        this.current = null;
        return null;
    }

    private InternalTableIterator openNextFile() {
        FileMetaData fileMetaData = this.files.get(this.index);
        ++this.index;
        return this.tableCache.newIterator(fileMetaData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConcatenatingIterator");
        sb.append("{index=").append(this.index);
        sb.append(", files=").append(this.files);
        sb.append(", current=").append(this.current);
        sb.append('}');
        return sb.toString();
    }
}

