/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.password;

import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.password.PasswordRestriction;
import org.jboss.as.domain.management.security.password.PasswordValidationException;

public class UsernamePasswordMatch
implements PasswordRestriction {
    private final boolean must;

    public UsernamePasswordMatch(boolean must) {
        this.must = must;
    }

    @Override
    public String getRequirementMessage() {
        if (this.must) {
            return DomainManagementLogger.ROOT_LOGGER.passwordUsernameMustMatchInfo();
        }
        return DomainManagementLogger.ROOT_LOGGER.passwordUsernameShouldMatchInfo();
    }

    @Override
    public void validate(String userName, String password) throws PasswordValidationException {
        if (userName.equals(password)) {
            throw this.must ? DomainManagementLogger.ROOT_LOGGER.passwordUsernameMatchError() : DomainManagementLogger.ROOT_LOGGER.passwordUsernameShouldNotMatch();
        }
    }
}

