/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.stax.impl.securityToken;

import java.io.IOException;
import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.kerberos.KerberosContextAndServiceNameCallback;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.apache.wss4j.common.kerberos.KerberosServiceExceptionAction;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoder;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderException;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderImpl;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.stax.ext.WSInboundSecurityContext;
import org.apache.wss4j.stax.securityToken.KerberosServiceSecurityToken;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InboundSecurityContext;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.impl.securityToken.AbstractInboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenConstants;

public class KerberosServiceSecurityTokenImpl
extends AbstractInboundSecurityToken
implements KerberosServiceSecurityToken {
    private CallbackHandler callbackHandler;
    private byte[] binaryContent;
    private String kerberosTokenValueType;
    private KerberosTokenDecoder kerberosTokenDecoder;
    private Subject subject;
    private Principal principal;

    public KerberosServiceSecurityTokenImpl(WSInboundSecurityContext wsInboundSecurityContext, CallbackHandler callbackHandler, byte[] binaryContent, String kerberosTokenValueType, String id, SecurityTokenConstants.KeyIdentifier keyIdentifier) {
        super((InboundSecurityContext)wsInboundSecurityContext, id, keyIdentifier, true);
        this.callbackHandler = callbackHandler;
        this.binaryContent = binaryContent;
        this.kerberosTokenValueType = kerberosTokenValueType;
    }

    public boolean isAsymmetric() throws XMLSecurityException {
        return false;
    }

    public SecurityTokenConstants.TokenType getTokenType() {
        return WSSecurityTokenConstants.KerberosToken;
    }

    protected KerberosTokenDecoder getTGT() throws WSSecurityException {
        try {
            KerberosContextAndServiceNameCallback contextAndServiceNameCallback = new KerberosContextAndServiceNameCallback();
            this.callbackHandler.handle(new Callback[]{contextAndServiceNameCallback});
            if (contextAndServiceNameCallback.getContextName() == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosCallbackContextNameNotSupplied");
            }
            if (contextAndServiceNameCallback.getServiceName() == null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosCallbackServiceNameNotSupplied");
            }
            LoginContext loginContext = new LoginContext(contextAndServiceNameCallback.getContextName(), this.callbackHandler);
            loginContext.login();
            this.subject = loginContext.getSubject();
            String service = contextAndServiceNameCallback.getServiceName();
            if (service == null) {
                Set<Principal> principals = this.subject.getPrincipals();
                if (principals.isEmpty()) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", new Object[]{"No Client principals found after login"});
                }
                service = principals.iterator().next().getName();
            }
            KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(this.binaryContent, service, contextAndServiceNameCallback.isUsernameServiceNameForm(), false);
            KerberosServiceContext krbServiceCtx = null;
            try {
                krbServiceCtx = (KerberosServiceContext)Subject.doAs(this.subject, action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof WSSecurityException) {
                    throw (WSSecurityException)cause;
                }
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, new Exception(cause), "kerberosTicketValidationError");
            }
            this.principal = krbServiceCtx.getPrincipal();
            final Key sessionKey = krbServiceCtx.getSessionKey();
            if (null != sessionKey) {
                return new KerberosTokenDecoder(){

                    public void setToken(byte[] token) {
                    }

                    public void setSubject(Subject subject) {
                    }

                    public byte[] getSessionKey() throws KerberosTokenDecoderException {
                        return sessionKey.getEncoded();
                    }

                    public void clear() {
                    }
                };
            }
            KerberosTokenDecoderImpl kerberosTokenDecoder = new KerberosTokenDecoderImpl();
            kerberosTokenDecoder.setToken(this.binaryContent);
            kerberosTokenDecoder.setSubject(this.subject);
            return kerberosTokenDecoder;
        }
        catch (IOException | UnsupportedCallbackException | LoginException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
        }
    }

    protected Key getKey(String algorithmURI, XMLSecurityConstants.AlgorithmUsage algorithmUsage, String correlationID) throws XMLSecurityException {
        byte[] sk;
        Key key = (Key)this.getSecretKey().get(algorithmURI);
        if (key != null) {
            return key;
        }
        if (this.kerberosTokenDecoder == null) {
            this.kerberosTokenDecoder = this.getTGT();
        }
        try {
            sk = this.kerberosTokenDecoder.getSessionKey();
        }
        catch (KerberosTokenDecoderException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN, (Exception)((Object)e));
        }
        key = KeyUtils.prepareSecretKey((String)algorithmURI, (byte[])sk);
        this.setSecretKey(algorithmURI, key);
        return key;
    }

    @Override
    public byte[] getBinaryContent() {
        return this.binaryContent;
    }

    @Override
    public String getKerberosTokenValueType() {
        return this.kerberosTokenValueType;
    }

    @Override
    public Subject getSubject() throws WSSecurityException {
        return this.subject;
    }

    @Override
    public Principal getPrincipal() throws WSSecurityException {
        return this.principal;
    }
}

